/*----------------------------------------------------------------------
ElectriCity

This class is the superclass for every object. 
It contains the member variables and the methods.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class ACEnergyObject{
  //x-coordinate, y-coordinate, width of an object
  float Posx; float Posy; float Width;
  
  //the distance of an object to the screens centre (multiplied by zoom for the real distance)
  float ShiftX; float ShiftY;
  
  //describes how far the corner of the object has to be moved away from the field in order to be placed correctly on it
  float MoveX; float MoveY;
  
  //appearance of the object
  PImage Image;
  
  //Size of the object (multiplied by zoom for the real size) 
  float SizeX; float SizeY; 
  
  //defines the ratio between SizeX and SizeY
  float SizeXMultiplier = 7.3; float SizeYMultiplier = 7.1;
  
  //the x-coordinate of the point in the middle of the object
  float MiddleX; 
  
  //y-coordinate of the right and the left corner
  float MiddleYRight; float MiddleYLeft;
  
  //defines what kind of object it is (for example "AKW")
  String Kind;
  
  //should have been the effect on the populations happyness, changed to number of workers in the end (10 workers resemble 1)
  int Happyness;
  
  //in kWh/month
  int Production;
  
  //in kWh/month
  int AverageProduction;
  
  //in swiss Francs/month
  int PermanentCost;
  
  //in swiss Francs
  long InvestmentCost;
  
  //in kg/month
  int Emissions;
  
  //draws every object
  void display(){
    Posx = ShiftX*main.Zoom+width/2.0;
    Posy = ShiftY*main.Zoom+height/2.0;
    image(Image, Posx, Posy, SizeX*main.Zoom, SizeY*main.Zoom);
  }
  
  //moves the object
  void move(){
    Posx = mouseX-(SizeX*main.Zoom)/2.0;
    Posy = mouseY-(SizeY*main.Zoom)/2.0;
    ShiftX = (Posx-width/2.0)/main.Zoom;
    ShiftY = (Posy-height/2.0)/main.Zoom;
    main.display();
  }
  
  // starts building the object
  void build(){
    build.hide();
    window = Window.Building;  
    ShiftX = (Posx-width/2.0)/main.Zoom;
    ShiftY = (Posy-height/2.0)/main.Zoom;    
    main.display();
  }
  
  //places the object at the nearest position
  void place(){
    boolean yCoord = false;
    for(int i = main.XCoord.size()-1; i >= 0; i--){
      if((main.XCoord.get(i) >= Posx-main.x*main.Zoom/2.0) && (main.XCoord.get(i) < Posx+main.x*main.Zoom/2.0)){
        Posx = main.XCoord.get(i)-main.Zoom*MoveX;
        if(i%2 == 0){
          yCoord = false;
        }else{
          yCoord = true;
        }
        break;
      }
    }
    if (yCoord){
      for(int i = main.YCoord1.size()-1; i >= 0; i--){
      if((main.YCoord1.get(i) > Posy-main.y*main.Zoom) && (main.YCoord1.get(i) <= Posy+main.y*main.Zoom)){
        Posy = main.YCoord1.get(i)-main.Zoom*MoveY;
        break;
      }
    }
    }else{
      for(int i = main.YCoord2.size()-1; i >= 0; i--){
        if((main.YCoord2.get(i) > Posy-main.y*main.Zoom) && (main.YCoord2.get(i) <= Posy+main.y*main.Zoom)){
          Posy = main.YCoord2.get(i)-main.Zoom*MoveY;
          break;
        }
      }
    }
    ShiftX = (Posx-width/2.0)/main.Zoom;
    ShiftY = (Posy-height/2.0)/main.Zoom;
    
    //sorts the ArrayList depending on the objects positions
    for(int i = 0; i < Object.size(); i++){
      ACEnergyObject object = Object.get(0);
      int k = 0;
      for (int j = 0; j < Object.size()-i;j++){
        ACEnergyObject objects = Object.get(j);
        if(objects.Posx+objects.MiddleX*main.Zoom>object.Posx+object.MiddleX*main.Zoom){
          if(objects.MiddleYLeft*main.Zoom+objects.Posy<object.MiddleYRight*main.Zoom+object.Posy){
            object = objects;
            k = j;
          }
        } else {
          if(objects.MiddleYRight*main.Zoom+objects.Posy<object.MiddleYLeft*main.Zoom+object.Posy){
            object = objects;
            k = j;
          }
        }
      }
      Object.add(object);
      Object.remove(k);
    }
    
    Money = Money-BuildingObject.InvestmentCost;
    main.display();
  }
  
  //checks if the object can be placed at the nearest position
  boolean ground(){
    float posx = Posx;
    float posy = Posy; 
    boolean yCoord = false;
    for(int i = main.XCoord.size()-1; i >= 0; i--){
      if((main.XCoord.get(i) >= posx-main.x*main.Zoom/2.0) && (main.XCoord.get(i) < posx+main.x*main.Zoom/2.0)){
        posx = main.XCoord.get(i)-main.Zoom*MoveX;
        if(i%2 == 0){
          yCoord = false;
        }else{
          yCoord = true;
        }
        break;
      }
    }
    if (yCoord){
      for(int i = main.YCoord1.size()-1; i >= 0; i--){
      if((main.YCoord1.get(i) > posy-main.y*main.Zoom) && (main.YCoord1.get(i) <= posy+main.y*main.Zoom)){
        posy = main.YCoord1.get(i)-main.Zoom*MoveY;
        break;
      }
    }
    }else{
      for(int i = main.YCoord2.size()-1; i >= 0; i--){
        if((main.YCoord2.get(i) > posy-main.y*main.Zoom) && (main.YCoord2.get(i) <= posy+main.y*main.Zoom)){
          posy = main.YCoord2.get(i)-main.Zoom*MoveY;
          break;
        }
      }
    }
    
    int counter = 0;
    for(int i = 0; i < Object.size()-1; i++){
      ACEnergyObject checkObject = Object.get(i);
      int[] x = new int[0];
      int[] y = new int[0];
      for(int j = 0; j < width; j+=5){
        for(int k = 0; k < height; k+=5){
          

          if((k-(checkObject.Posy+checkObject.MiddleYRight*main.Zoom)<-3.0/4.0*(j-(checkObject.Posx+(checkObject.MiddleX+checkObject.Width)*main.Zoom)))&&
            (k-(checkObject.Posy+checkObject.MiddleYLeft*main.Zoom)<3.0/4.0*(j-(checkObject.Posx+(checkObject.MiddleX-checkObject.Width)*main.Zoom)))&&
            (k-(checkObject.Posy+checkObject.MiddleYRight*main.Zoom)>3.0/4.0*(j-(checkObject.Posx+(checkObject.MiddleX+checkObject.Width)*main.Zoom)))&&
            (k-(checkObject.Posy+checkObject.MiddleYLeft*main.Zoom)>-3.0/4.0*(j-(checkObject.Posx+(checkObject.MiddleX-checkObject.Width)*main.Zoom)))
            ){

              x = expand(x, x.length+1);
              y = expand(y, y.length+1);
              x[(x.length-1)]=j;
              y[(y.length-1)]=k;
            }
        }
      }
      for(int j = 0; j < width; j+=5){
        for(int k = 0; k < height; k+=5){
          if((k-(Posy+MiddleYRight*main.Zoom)<-3.0/4.0*(j-Posx-(MiddleX+Width)*main.Zoom))&&
            (k-(Posy+MiddleYLeft*main.Zoom)<3.0/4.0*(j-Posx-(MiddleX-Width)*main.Zoom))&&
            (k-(Posy+MiddleYRight*main.Zoom)>3.0/4.0*(j-Posx-(MiddleX+Width)*main.Zoom))&&
            (k-(Posy+MiddleYLeft*main.Zoom)>-3.0/4.0*(j-Posx-(MiddleX-Width)*main.Zoom))
            ){
              for(int l = 0; l < x.length; l++){
                if((j == x[l]) && (k == y[l])){
                  return false;
                }   
              }
            }
        }
      }
      counter++;
    }
    if(counter == Object.size()-1){
      return true;
    }
    else{
      return false;
    }
  }
}
