/*----------------------------------------------------------------------
ElectriCity

This class contains all the information about nuclear powerplants.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 16.10.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CAKW extends ACEnergyObject{

    CAKW(){
      Image = ImgAKW;
      //size of a nuclear powerplant
      float Size = 3.8*4;
      SizeX = SizeXMultiplier*Size; 
      SizeY = SizeYMultiplier*Size;
      MiddleX=27.8*2; MiddleYRight=28.2*2; MiddleYLeft=34.2*2;
      Width = 17*2;
      MoveX = -0.003*SizeX;
      MoveY = 0.005*SizeY-main.y;
      Happyness = -5000;
      Production = 487000000;
      AverageProduction = 487000000;
      PermanentCost = 19480000;
      InvestmentCost = 3260000000l;
      Emissions = 7305;
      Kind = "AKW";
    }
}
class CAKWsmall extends CAKW{
  CAKWsmall(){
    //size of a small nuclear powerplant
    float Size = 3.8*2;
    SizeX = SizeXMultiplier*Size; 
    SizeY = SizeYMultiplier*Size;
    MiddleX=27.8; MiddleYRight=28.2; MiddleYLeft=34.2;
    Width = 17;
    MoveX = -0.003*SizeX;
    MoveY = 0.005*SizeY-main.y;
    Happyness = -50;
    Production = 4870000;
    AverageProduction = 4870000;
    PermanentCost = 194800;
    InvestmentCost = 32600000;
    Emissions = 7;
    Kind = "AKWs";
  }
}
