/*----------------------------------------------------------------------
ElectriCity

This class opens the window, where you can choose which object you want to build.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CBuild{
  //space between two buttons (production)
  int SpaceXP;
  
  //space between two buttons (consumers)
  int SpaceXC;
  
  //space between two buttons in y-direction
  int SpaceY;
  
  //builds the window
  void setup(){
       PFont build = Calibri; 
       ControlFont font = new ControlFont(build, 20);
       PFont exit = Calibri; 
       ControlFont exitFont = new ControlFont(exit);
       cp5Build.setFont(font);

       SpaceXP = (width-1200)/5;
       SpaceXC = (width-900)/4;
       SpaceY = (height-600)/4-30;
       
       PImage imgAKW = ImgAKW;
       imgAKW.resize(300, 300);
       PImage imgCoal = ImgCoal;
       imgCoal.resize(300, 300);
       PImage imgSolar = ImgSolar;
       imgSolar.resize(300, 300);
       PImage imgWind = ImgWind;
       imgWind.resize(300, 300);
       PImage imgHH = ImgHH;
       imgHH.resize(300, 300);
       PImage imgIB = ImgIB;
       imgIB.resize(300, 300);
       PImage imgPSW = ImgPSW;
       imgPSW.resize(300,300);
    
    //all buttons
    //build buttons
     BBuildExit = cp5Build.addButton("BBuildExit")
     .setLabel("<-")
     .setPosition(20, 20)
     .setSize(70,70)
     .setFont(exitFont)
     ;
     BBuildExit.hide();
     
    BBuildAKW = cp5Build.addButton("BBuildAKW")
     .setImage(imgAKW)
     .setPosition(SpaceXP, SpaceY)
     .setSize(300,300)
     ;
     BBuildAKW.hide();
     
     BBuildCoal = cp5Build.addButton("BBuildCoal")
     .setImage(imgCoal)
     .setPosition(2*SpaceXP + 300, SpaceY)
     .setSize(300,300)
     ;
     BBuildCoal.hide();
     
     BBuildWind = cp5Build.addButton("BBuildWind")
     .setImage(imgWind)
     .setPosition(3*SpaceXP+600, SpaceY)
     .setSize(300,300)
     ;
     BBuildWind.hide();
     
     BBuildPV = cp5Build.addButton("BBuildPV")
     .setImage(imgSolar)
     .setPosition(4*SpaceXP+900, SpaceY)
     .setSize(300,300)
     ;
     BBuildPV.hide();
     
     BBuildHH = cp5Build.addButton("BBuildHH")
     .setImage(imgHH)
     .setPosition(SpaceXC, 3*SpaceY+300)
     .setSize(300,300)
     ;
     BBuildHH.hide();
     
     BBuildIB = cp5Build.addButton("BBuildIB")
     .setImage(imgIB)
     .setPosition(2*SpaceXC + 300, 3*SpaceY+300)
     .setSize(300,300)
     ;
     BBuildIB.hide();
     
     BBuildPSW = cp5Build.addButton("BBuildPSW")
     .setImage(imgPSW)
     .setPosition(3*SpaceXC+600,3*SpaceY+300)
     .setSize(300,300)
     ;
     BBuildPSW.hide();
    
  
    //detailsButtons  
    BDetailsAKW = cp5Build.addButton("BDetailsAKW")
     .setLabel("nuclear power plant")
     .setPosition(SpaceXP, SpaceY+310)
     .setSize(300,80)
     ;
     BDetailsAKW.hide();
     
     BDetailsCoal = cp5Build.addButton("BDetailsCoal")
     .setLabel("coal-fired power station")
     .setPosition(2*SpaceXP + 300, SpaceY+310)
     .setSize(300,80)
     ;
     BDetailsCoal.hide();
     
     BDetailsWind = cp5Build.addButton("BDetailsWind")
     .setLabel("wind turbine")
     .setPosition(3*SpaceXP+600, SpaceY+310)
     .setSize(300,80)
     ;
     BDetailsWind.hide();
     
     BDetailsPV = cp5Build.addButton("BDetailsPV")
     .setLabel("photovoltaic")
     .setPosition(4*SpaceXP+900, SpaceY+310)
     .setSize(300,80)
     ;
     BDetailsPV.hide();
     
     BDetailsHH = cp5Build.addButton("BDetailsHH")
     .setLabel("household")
     .setPosition(SpaceXC, 3*SpaceY+610)
     .setSize(300,80)
     ;
     BDetailsHH.hide();
     
     BDetailsIB = cp5Build.addButton("BDetailsIB")
     .setLabel("industrial building")
     .setPosition(2*SpaceXC + 300, 3*SpaceY+610)
     .setSize(300,80)
     ;
     BDetailsIB.hide();
     
     BDetailsPSW = cp5Build.addButton("BDetailsPSW")
     .setLabel("storage plant")
     .setPosition(3*SpaceXC+600,3*SpaceY+610)
     .setSize(300,80)
     ;
     BDetailsPSW.hide();

    
  }
  //draws the background and shows every button
  void display(){
    background(255,255,255);
    BBuildExit.show();
    BBuildAKW.show();
    BBuildCoal.show();
    BBuildPSW.show();
    BBuildWind.show();
    BBuildPV.show();
    BBuildHH.show();
    BBuildIB.show();
    BDetailsAKW.show();
    BDetailsCoal.show();
    BDetailsPSW.show();
    BDetailsWind.show();
    BDetailsPV.show();
    BDetailsHH.show();
    BDetailsIB.show();
  }
  
  //hides every button
  void hide(){
    BBuildExit.hide();
    BBuildAKW.hide();
    BBuildCoal.hide();
    BBuildPSW.hide();
    BBuildWind.hide();
    BBuildPV.hide();
    BBuildHH.hide();
    BBuildIB.hide();
    BDetailsAKW.hide();
    BDetailsCoal.hide();
    BDetailsPSW.hide();
    BDetailsWind.hide();
    BDetailsPV.hide();
    BDetailsHH.hide();
    BDetailsIB.hide();
  }
}
