/*----------------------------------------------------------------------
ElectriCity

This class contains all the information about coal-fired powerplants.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CCoal extends ACEnergyObject{
  CCoal(){
      Image = ImgCoal; 
      //size of a coal-fired powerplant
      float Size = 1.7*8;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      Width = 7.1*2;
      MoveX = 0.4/10*SizeX-8.0/3.0;
      MoveY = 0.88/10*SizeY-2;
      MiddleX = 25.3*2; MiddleYRight = 34.3*2; MiddleYLeft = 37.4*2;
      Happyness = -1380;
      Production = 302000000;
      AverageProduction = 302000000;
      PermanentCost = 2250000;
      InvestmentCost = 759000000;
      Emissions = 381915000;
      Kind = "Coal";
    }
}
class CCoalsmall extends CCoal{
  CCoalsmall(){
      Image = ImgCoal; 
      //size of a coal-fired powerplant
      float Size = 1.7*4;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      Width = 7.1;
      MoveX = 0.4/10*SizeX-8.0/3.0;
      MoveY = 0.88/10*SizeY-2;
      MiddleX = 25.3; MiddleYRight = 34.3; MiddleYLeft = 37.4;
      Happyness = -14;
      Production = 3020000;
      AverageProduction = 3020000;
      PermanentCost = 22500;
      InvestmentCost = 7590000;
      Emissions = 3819150;
      Kind = "Coals";
    }
}
