/*----------------------------------------------------------------------
ElectriCity

This opens a window which shows the detailed information about an object.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CDetails{
  //titles of the window
  String prod = "energy production";
  String invest = "investment cost";
  String monthly = "mothly profit";
  String emissions = "emissions";
  String happyness = "workers";
  
  //name of the objects image
  String ImageName;
  
  //name of the creator of the objects image
  String ImageCreator;
  
  //other text needed for the license
  String Attribution = "Creators Common Attribution";
  String By = "by ";
  String Licensed = "is licensed under "; 
  
  //link to find the image
  String LinkImage;
  
  //link to find the creator
  String LinkCreator;
  
  //builds the window
  void setup(){
    PFont details = Calibri; 
     ControlFont exit = new ControlFont(details);
     cp5Details.setFont(exit);
     
    BDetailsExit = cp5Details.addButton("BDetailsExit")
     .setLabel("<-")
     .setPosition(20, 20)
     .setSize(70,70)
     ;
     BDetailsExit.hide();
  }
  
  //shows the window
  void display(){
    BDetailsExit.show();
    background(255,255,255);
    stroke(0,0,0);
    noFill();
    
    //structure
    strokeWeight(2);
    line(20, 100, width-20, 100);
    for(int i = 1; i < 6; i++){ 
      line((width-40)/6*i, 30, (width-40)/6*i, 240);
    }
    
    fill(main.Dark);
    textFont(Calibri, 30);
    
    //titles
    text(prod, (width-40)/6+((width-40)/6-textWidth(prod))/2, 70);
    text(invest, (width-40)/6*2+((width-40)/6-textWidth(invest))/2, 70);
    text(monthly, (width-40)/6*3+((width-40)/6-textWidth(monthly))/2, 70);
    text(emissions, (width-40)/6*4+((width-40)/6-textWidth(emissions))/2, 70);
    text(happyness, (width-40)/6*5+((width-40)/6-textWidth(happyness))/2, 70);
    
    text(DetailsTitle, ((width-40)/6-textWidth(DetailsTitle))/2, 140);
    text(DetailsTitle2, ((width-40)/6-textWidth(DetailsTitle2))/2, 190);
    
    //values
    text(str(Objects.AverageProduction), (width-40)/6+((width-40)/6-textWidth(str(Objects.AverageProduction)))/2, 140);
    text(str(Objects2.AverageProduction), (width-40)/6+((width-40)/6-textWidth(str(Objects2.AverageProduction)))/2, 190);
    text("\nkWh/month", (width-40)/6+((width-40)/6-textWidth("\nkWh/month"))/2, 190);
    
    text(Objects.InvestmentCost+"", (width-40)/6*2+((width-40)/6-textWidth(Objects.InvestmentCost+""))/2, 140);
    text(Objects2.InvestmentCost+"", (width-40)/6*2+((width-40)/6-textWidth(Objects2.InvestmentCost+""))/2, 190);
    text("\n$", (width-40)/6*2+((width-40)/6-textWidth("\n$"))/2, 190);
    
    text(str(-Objects.PermanentCost), (width-40)/6*3+((width-40)/6-textWidth(str(-Objects.PermanentCost)))/2, 140);
    text(str(-Objects2.PermanentCost), (width-40)/6*3+((width-40)/6-textWidth(str(-Objects2.PermanentCost)))/2, 190);
    text("\n$/month", (width-40)/6*3+((width-40)/6-textWidth("\n$/month"))/2, 190);
    
    text(str(Objects.Emissions), (width-40)/6*4+((width-40)/6-textWidth(str(Objects.Emissions)))/2, 140);
    text(str(Objects2.Emissions), (width-40)/6*4+((width-40)/6-textWidth(str(Objects2.Emissions)))/2, 190);
    text("\nkg(CO2)/month", (width-40)/6*4+((width-40)/6-textWidth("\nkg(CO2)/month"))/2, 190);
    
    text(str(Objects.Happyness), (width-40)/6*5+((width-40)/6-textWidth(str(Objects.Happyness)))/2, 140);
    text(str(Objects2.Happyness), (width-40)/6*5+((width-40)/6-textWidth(str(Objects2.Happyness)))/2, 190);
    
    //image
    image(DetailsImage, 40, 400, width/2+200, height-500);
    
    
    //license
    textFont(Calibri, 20);
    fill(70,186,224);
    text(ImageName, width-30-textWidth(ImageName)-textWidth(By)-textWidth(ImageCreator)-textWidth(Licensed)-textWidth(Attribution) ,height-30);
    text(ImageCreator, width-30-textWidth(ImageCreator)-textWidth(Licensed)-textWidth(Attribution) , height-30);
    text(Attribution, width-30-textWidth(Attribution) , height-30);
    fill(0);
    text(By, width-30-textWidth(By)-textWidth(ImageCreator)-textWidth(Licensed)-textWidth(Attribution) , height-30);
    text(Licensed, width-30-textWidth(Licensed)-textWidth(Attribution) , height-30);
  }

  //hides the button
  void hide(){
   BDetailsExit.hide(); 
  }
}
