/*----------------------------------------------------------------------
ElectriCity

This opens the window, where you can pay your emission taxes.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CEmissionTaxes extends PApplet {
  //the windows size
  public void settings() {
    size(400, 250);
  }
  
  //sets the window invisible
  public void setup(){
    surface.setVisible(false); 
  }
  
  //opens the window
  void open(){
    surface.setVisible(true);
    Taxe = true;
  }
  
  //closes the window
  void hide(){
    surface.setVisible(false); 
    Taxe = false;
  }
  
  //draws texts, lines and buttons
  public void draw() {
    background(0);
    textFont(Calibri);
    fill(255, 0, 0);
    String text = "Attention!";
    text(text, width/2-textWidth(text)/2, 50);
    stroke(255,0,0);
    line(0,70,width,70);
    text = "Your emission taxes are due!";
    textFont(Calibri, 30);
    text(text, width/2-textWidth(text)/2, 100);
    text = "You have to pay:";
    text(text, width/2-textWidth(text)/2, 150);
    
    String emissions = Long.toString(CO2/1000*Tax) + " $";
    if(CO2/100000000 > 1000000000){
      emissions = str(round(CO2/10000000/100000000))+" P";
    }
    else if(CO2/100000 > 1000000000){
      emissions = str(round(CO2/100000/10000000))+" G";
    }
    else if(CO2/100 > 1000000000){
      emissions = str(round(CO2/1000000000))+" M";
    }else if(CO2 > 100000000){
      emissions = str(round(CO2/1000000))+" k";
    }
    text(emissions, (width-100)/2-textWidth(emissions)/2, 200);
    noStroke();
    if(mouseX > 240 && mouseX < 370 && mouseY > 170 && mouseY < 210){
      fill(0,116,217);
    } else {
      fill(0,45,90);
    }
    rect(240,170,130,40);
    fill(255);
    textFont(Calibri, 30);
    text("Pay now", 250, 200);
  }
  
  //checks if the button has been pressed when the mouse is released and if so, pays the emission taxes
  public void mouseReleased(){
    if(mouseX > 240 && mouseX < 370 && mouseY > 170 && mouseY < 210){
      Money-=CO2/1000*Tax;
      CO2 = 0;
      hide();
      report.hide();
      main.display();
      window = Window.Main;
    }
  }
  
  //makes sure you can't close the window
  @Override
    public void exit() {
  }
}
