/*----------------------------------------------------------------------
ElectriCity

This class draws the main window including the background and every 
object you built.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 05.10.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CMain{
      
  // creates the window with all components (except from the background)
  void setup(){ 
     PFont mainLabels = Calibri; 
     ControlFont labels = new ControlFont(mainLabels, 20);
  
     PFont main = Calibri; 
     ControlFont font = new ControlFont(main, 30);
     cp5Main.setFont(font);
     
     PFont mainExit = Calibri; 
     ControlFont exit = new ControlFont(mainExit);
    
     BBuild = cp5Main.addButton("BBuild")
     .setLabel("Build")
     .setPosition(width-440,height-120)
     .setSize(200,100)
     ;
     BBuild.hide();
     
     BSimulate = cp5Main.addButton("BSimulate")
     .setLabel("Simulate")
     .setPosition(width-220,height-120)
     .setSize(200,100)
     ;
     BSimulate.hide();
     
     BExpectation = cp5Main.addButton("BExpectation")
     .setLabel("Expectation")
     .setPosition(width-660,height-120)
     .setSize(200,100)
     ;
     BExpectation.hide();
     
     BExit = cp5Main.addButton("BExit")
     .setLabel("<-")
     .setFont(exit)
     .setPosition(20,20)
     .setSize(70,70)
     ;
     BExit.hide();
     
     SZoom = cp5Main.addSlider("SZoom")
     .setPosition(width-100,height/2-250)
     .setSize(50,500)
     .setRange(3,90)
     .setValue(15)
     .setSliderMode(Slider.FLEXIBLE)
     .setHandleSize(70)
     ;
     SZoom.getValueLabel().hide();
     SZoom.getCaptionLabel().hide();
     SZoom.hide();
     
     LMonth = cp5Main.addButton("LMonth")
                  .setLabel("Month: "+str(Month))
                  .setPosition(width-500,20)
                  .setSize(200,40)
                  .setFont(labels)
                  .hide()
                  ;
                  
    LYear = cp5Main.addButton("LYear")
                  .setLabel("Year: "+str(Year))
                  .setPosition(width-750,20)
                  .setSize(200,40)
                  .setFont(labels)
                  .hide()
                  ;
                  
    LWorkers = cp5Main.addButton("LWorkers")
                  .setLabel("Workers: "+str(Workers))
                  .setPosition(width-250,20)
                  .setSize(200,40)
                  .setFont(labels)
                  .hide()
                  ;
                  
    LMoney = cp5Main.addButton("LMoney")
                  .setLabel("Money: "+str(Money))
                  .setPosition(width-250,70)                  
                  .setSize(200,40)
                  .setFont(labels)
                  .hide()
                  ;
                  
    LEnergy = cp5Main.addButton("LEnergy")
                  .setLabel("Energy: "+str(Energy))
                  .setPosition(width-250,120)                  
                  .setSize(200,40)
                  .setFont(labels)
                  .hide()
                  ;
                  
   LCO2 = cp5Main.addButton("LCO2")
                  .setLabel("Emissions: "+ str(CO2))
                  .setPosition(width-250,170)                  
                  .setSize(200,40)
                  .setFont(labels)
                  .hide()
                  ;
  }

  // shows everything in main (called when the window is opened)
  void display(){
    bg();
    BBuild.show();
    BSimulate.show();
    BExpectation.show();
    BExit.show();
    SZoom.show();
    String money = str(round(Money))+" $";
    String energy = str(round(Energy))+" k";
    String emissions = str(round(CO2))+" kg";
    
    if(Money/100000000 > 1000000000){
      money = str(round(Money/10000000/100000000))+" P";
    }
    else if(Money/100000 > 1000000000){
      money = str(round(Money/100000/10000000))+" T";
    }
    else if(Money/100 > 1000000000){
      money = str(round(Money/1000000000))+" G";
    }else if(Money > 100000000){
      money = str(round(Money/1000000))+" M";
    }else if(Money > 100000){
      money = str(round(Money/1000))+" k";
    }
    
    if(Energy/100000000 > 1000000000){
      energy = str(round(Energy/10000000/100000000))+" E";
    }
    else if(Energy/100000 > 1000000000){
      energy = str(round(Energy/100000/10000000))+" P";
    }
    else if(Energy/100 > 1000000000){
      energy = str(round(Energy/1000000000))+" T";
    }else if(Energy > 100000000){
      energy = str(round(Energy/1000000))+" G";
    }else if(Energy > 100000){
      energy = str(round(Energy/1000))+" M";
    }
    
    
    if(CO2/100000000 > 1000000000){
      emissions = str(round(CO2/10000000/100000000))+" Pt";
    }
    else if(CO2/100000 > 1000000000){
      emissions = str(round(CO2/100000/10000000))+" Gt";
    }
    else if(CO2/100 > 1000000000){
      emissions = str(round(CO2/1000000000))+" Mt";
    }else if(CO2 > 100000000){
      emissions = str(round(CO2/1000000))+" kt";
    }else if(CO2 > 100000){
      emissions = str(round(CO2/1000))+" t";
    }
    
    String month = "January";
    switch(Month){
      case 2: month = "february"; break;
      case 3: month = "march"; break;
      case 4: month = "april"; break;
      case 5: month = "may"; break;
      case 6: month = "june"; break;
      case 7: month = "july"; break;
      case 8: month = "august"; break;
      case 9: month = "september"; break;
      case 10: month = "october"; break;
      case 11: month = "november"; break;
      case 12: month = "december"; break;
      default: break;
    }
    
    LMonth.setLabel("Month: "+month);
    LWorkers.setLabel("Workers: "+str(Workers));
    LMoney.setLabel("Money: "+money);
    LEnergy.setLabel("Energy: "+energy+"Wh");
    LCO2.setLabel("Emissions: "+ emissions);
    LYear.setLabel("Year: "+ str(Year));
    LMonth.show();
    LWorkers.show();
    LMoney.show();
    LEnergy.show();
    LCO2.show();
    LYear.show();
    
    //for (int i = Object.size()-1; i >= 0; i--){
      for (int i = 0; i<Object.size(); i++){
      ACEnergyObject object = Object.get(i);
      object.display();
    }
  }
  
  // hides everything in main (called when the window is closed)
  void hide(){
    BBuild.hide();
    BSimulate.hide();
    BExpectation.hide();
    BExit.hide();
    SZoom.hide();
    LMonth.hide();
    LWorkers.hide();
    LMoney.hide();
    LEnergy.hide();
    LCO2.hide();
    LYear.hide();
    Grabbed = false;
  }
  
  //here is everything for the background
  //x-coordinate
  float PosX = 0;
  
  //y-coordinate
  float PosY = 0;
  
  //number to remember how big everything has to be
  float Zoom = 15;
  
  //checks if the background has been grabbed (= has to follow the mouse)
  boolean Grabbed = false;
  
  //dark green
  color Dark = color(1,110,9);
  
  //light green
  color Light = color(91,217,35);
  
  //width of one field
  float x = 4.0/3.0;
  
  //height of one field
  float y = 1;
  
  //stores the x-coordinates of every field
  IntList XCoord = new IntList();
  
  //stores the y-coordinates of every field in an odd column
  IntList YCoord1 = new IntList();
  
  //stores the y-coordinates of every field in an even column
  IntList YCoord2 = new IntList();
  
  //checks if the current column is even or odd
  boolean YCoord = false;
  
  //draws and calculates the background
  void bg(){
    background(Dark);
    float iChange = x*Zoom;
    float jChange = y*Zoom;
    float numberX = (int)((float)(width/2)/((float)(iChange)));
    float numberY = (int)((float)(height/2)/((float)(jChange)));
    
    //prevents the background from flickering when zooming
    if(numberX%2 != 0){
      numberX++;
    }
    if(numberY%2 != 0){
      numberY++;
    }
    
    
    float posX0 = width/2-numberX*iChange-3*x*iChange+PosX;
    float posY0 = height/2-numberY*jChange-y*jChange+PosY;
    float j0 = posY0;
    int counter = 0;
    noStroke();
    
    
    //prevents the background from beginning inside the window
    while(PosX > x*Zoom){
        PosX-=2*x*Zoom;
      }while(PosX < -x*Zoom){
        PosX+=2*x*Zoom;
      }
      while(PosY > y*Zoom){
        PosY-=2*y*Zoom;
      }while(PosY < -y*Zoom){
        PosY+=2*y*Zoom;
      }
      
    // draws the background
    XCoord.clear();
    for(float i = posX0; i < (width+iChange); i+=iChange){
      XCoord.append((int)i);
      if(counter%2 == 0){
          fill(Dark);
          YCoord1.clear();
          YCoord = true;
        }else{
          fill(Light);
          YCoord2.clear();
          YCoord = false;
        }
      for(float j = j0; j < (height+jChange); j+=2*jChange){
        if(YCoord){
          YCoord1.append((int)j); 
        }else{
          YCoord2.append((int)j);
        }
        quad(i, j, i+iChange, j+jChange, i+2*iChange, j, i+iChange, j-jChange);
      }
      if (j0 == posY0){
        j0 = posY0+jChange;
      }else{
        j0 = posY0;
      }
      counter++;
    }
  }
  
  //moves the background and every object
  void move(){
    // checks if the the mouse hasn't pressed a button or slider and moves the background
    if(!(BBuild.isPressed() || BSimulate.isPressed() || BExpectation.isPressed() || BExit.isPressed() || SZoom.isMouseOver())){
      PosX = PosX + mouseX - pmouseX;
      PosY = PosY + mouseY - pmouseY;
      
      // prevents the background from beginning inside the window
      while(PosX > x*Zoom){
        PosX-=2*x*Zoom;
      }while(PosX < -x*Zoom){
        PosX+=2*x*Zoom;
      }
      while(PosY > y*Zoom){
        PosY-=2*y*Zoom;
      }while(PosY < -y*Zoom){
        PosY+=2*y*Zoom;
      }
      //moves the objects
      for (int i = Object.size()-1; i >= 0; i--){
        ACEnergyObject object = Object.get(i);
        object.Posx = object.Posx + mouseX - pmouseX;
        object.Posy = object.Posy + mouseY - pmouseY;
        object.ShiftX = (object.Posx-width/2.0)/Zoom;
        object.ShiftY = (object.Posy-height/2.0)/Zoom;
      }
      // redraws the window
      display();
    }
  }
}
