/*----------------------------------------------------------------------
ElectriCity

This class is responsible for the simulation itself. It calculates your
monthly performance and opens a window which contains all this data.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 05.10.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CReport{
  //turns true if you don't produce enough electricity (-> you lose)
  boolean Die = false;
  
    //builds the window
    void setup(){
    PFont mainExit = Calibri; 
    ControlFont exit = new ControlFont(mainExit);
     
    BReportExit = cp5Report.addButton("BReportExit")
     .setLabel("OK")
     .setFont(exit)
     .setPosition(width-115, height-95)
     .setSize(100,80)
     ;
     BReportExit.hide();
  }
  
  //hides the button
  void hide(){
    BReportExit.hide();
  }
  
  //starts the simulation
  void simulate(){
    BReportExit.show();
    main.hide();
    window = Window.Simulate;
    background(255);
    int wind = 0;
    int windone = 0;
    int solar = 0;
    int solarone = 0;
    
    //simulates one month after another to check if you lose
    for(int i = 0; i < Duration; i++){
      windone = Wind.calcProduction();
      solarone = (int)Solar.calcProduction(Month, true);
      wind += windone;
      solar += solarone;
      if(getNr("PSW")*PSW.Production+getNr("PSWs")*PSWs.Production > Energy){
        if(getNr("AKW")*AKW.Production+getNr("AKWs")*AKWs.Production+getNr("Coal")*Coal.Production+getNr("Coals")*Coals.Production+windone*getNr("Wind")+windone*10*getNr("Windl")+solarone*100*getNr("Solarl")+solarone*getNr("Solar")+Energy < -(getNr("HouseHold")*HH.Production+getNr("HouseHoldl")*HHl.Production+getNr("IndustrialBuilding")*IB.Production+getNr("IBl")*IBl.Production)){
           dead.Reason = " because you didn't produce enough energy.";
           report.hide();
           dead.open();
           Die = true;
        }
      } else {
         if(getNr("AKW")*AKW.Production+getNr("AKWs")*AKWs.Production+getNr("Coal")*Coal.Production+getNr("Coals")*Coals.Production+windone*getNr("Wind")+windone*10*getNr("Windl")+solarone*100*getNr("Solarl")+solarone*getNr("Solar")+getNr("PSW")*PSW.Production+getNr("PSWs")*PSWs.Production < -(getNr("HouseHold")*HH.Production+getNr("HouseHoldl")*HHl.Production+getNr("IndustrialBuilding")*IB.Production+getNr("IBl")*IBl.Production)){
           dead.Reason = " because you didn't produce enough energy.";
           report.hide();
           dead.open();
           Die = true;
        }
      }
      if((getNr("AKW")*AKW.Production+getNr("AKWs")*AKWs.Production+getNr("Coal")*Coal.Production+getNr("Coals")*Coals.Production+windone*getNr("Wind")+windone*10*getNr("Windl")+solarone*100*getNr("Solarl")+solarone*getNr("Solar")+getNr("HouseHold")*HH.Production+getNr("HouseHoldl")*HHl.Production+getNr("IndustrialBuilding")*IB.Production+getNr("IBl")*IBl.Production)*0.8 > getNr("PSW")*PSW.Production+getNr("PSWs")*PSWs.Production){
         Energy += getNr("PSW")*PSW.Production+getNr("PSWs")*PSWs.Production;
      } else{
         Energy += (getNr("AKW")*AKW.Production+getNr("AKWs")*AKWs.Production+getNr("Coal")*Coal.Production+getNr("Coals")*Coals.Production+windone*getNr("Wind")+windone*10*getNr("Windl")+solarone*100*getNr("Solarl")+solarone*getNr("Solar")+getNr("HouseHold")*HH.Production+getNr("HouseHoldl")*HHl.Production+getNr("IndustrialBuilding")*IB.Production+getNr("IBl")*IBl.Production)*0.8;
    }
      Month++;
      if(Month == 13){
        Month = 1;
        Year++;
      }
    }
    
    //draws the window which shows you the results of the simulation
    int WindProd = wind * (int)getNr("Wind");
    int WindlProd = wind * 10 * (int)getNr("Windl");
    int SolarProd = solar * (int)getNr("Solar");
    int SolarlProd = solar * 100 * (int)getNr("Solarl");
    
    float placeY = height/11;
    float placeX = (width - 500)/5;
    StringList StringX = new StringList("nuclear powerplants:", "coal-fired power stations:", "wind turbines:", "photovoltaic:", "households:", "industrial buildings:", "storage plants:", "total:");
    StringList StringY = new StringList("amount:","energy-production:\n         (in kWh)","profit:\n (in $)","CO2-emissions:\n        (in kg)","workers:");
    StringList Data = new StringList((getNr("AKW")+getNr("AKWs"))+"", ((getNr("AKW")*AKW.Production+getNr("AKWs")*AKWs.Production)*Duration)+"",((getNr("AKW")*(-AKW.PermanentCost)+getNr("AKWs")*(-AKWs.PermanentCost))*Duration)+"",((getNr("AKW")*AKW.Emissions+getNr("AKWs")*AKWs.Emissions)*Duration)+"",(getNr("AKW")*AKW.Happyness+getNr("AKWs")*AKWs.Happyness)+"",
                                     (getNr("Coal")+getNr("Coals"))+"", ((getNr("Coal")*Coal.Production+getNr("Coals")*Coals.Production)*Duration)+"",((getNr("Coal")*(-Coal.PermanentCost)+getNr("Coals")*(-Coals.PermanentCost))*Duration)+"",((getNr("Coal")*Coal.Emissions+getNr("Coals")*Coals.Emissions)*Duration)+"",(getNr("Coal")*Coal.Happyness+getNr("Coals")*Coals.Happyness)+"",
                                     (getNr("Wind")+getNr("Windl"))+"", (WindProd+WindlProd)+"",((getNr("Wind")*(-Wind.PermanentCost)+getNr("Windl")*(-Windl.PermanentCost))*Duration)+"",((getNr("Wind")*Wind.Emissions+getNr("Windl")*Windl.Emissions)*Duration)+"",(getNr("Wind")*Wind.Happyness+getNr("Windl")*Windl.Happyness)+"",
                                     (getNr("Solar")+getNr("Solarl"))+"", (SolarProd+SolarlProd)+"",((getNr("Solar")*(-Solar.PermanentCost)+getNr("Solarl")*(-Solarl.PermanentCost))*Duration)+"",((getNr("Solar")*Solar.Emissions+getNr("Solarl")*Solarl.Emissions)*Duration)+"",(getNr("Solar")*Solar.Happyness+getNr("Solarl")*Solarl.Happyness)+"",
                                     (getNr("HouseHold")+getNr("HouseHoldl"))+"", ((getNr("HouseHold")*HH.Production+getNr("HouseHoldl")*HHl.Production)*Duration)+"",((getNr("HouseHold")*(-HH.PermanentCost)+getNr("HouseHoldl")*(-HHl.PermanentCost)*Duration))+"",((getNr("HouseHold")*HH.Emissions+getNr("HouseHoldl")*HHl.Emissions)*Duration)+"",(getNr("HouseHold")*HH.Happyness+getNr("HouseHoldl")*HHl.Happyness)+"",
                                     (getNr("IndustrialBuilding")+getNr("IndustrialBuildingl"))+"", ((getNr("IndustrialBuilding")*IB.Production+getNr("IndustrialBuildingl")*IBl.Production)*Duration)+"",((getNr("IndustrialBuilding")*(-IB.PermanentCost)+getNr("IndustrialBuildingl")*(-IBl.PermanentCost))*Duration)+"",((getNr("IndustrialBuilding")*IB.Emissions+getNr("IndustrialBuildingl")*IBl.Emissions)*Duration)+"",(getNr("IndustrialBuilding")*IB.Happyness+getNr("IndustrialBuildingl")*IBl.Happyness)+"",
                                     (getNr("PSW")+getNr("PSWs"))+"", str(0), ((getNr("PSW")*(-PSW.PermanentCost)+getNr("PSWs")*(-PSWs.PermanentCost))*Duration)+"", ((getNr("PSW")*PSW.Emissions+getNr("PSWs")*PSWs.Emissions)*Duration)+"", (getNr("PSW")*PSW.Happyness+getNr("PSWs")*PSWs.Happyness)+""
                                     );                          
    for (int k = 0; k <= 4; k++){
      long total = 0;      
      for (int i=k; i <= Data.size()-1; i += 5){
        total = total+int(Data.get(i));
      }
      switch(k){
       // case 1: Energy += total; break;
        case 2: Money = Money + total; break;
        case 3: CO2 = CO2 +total; break;
        default: break;
      }
      Data.append((total)+"");
    }
      
    
    fill(main.Dark);
    stroke(main.Dark);
    strokeWeight(2);
    line(50, height/11*9.5, width-50, height/11*9.5);
    textFont(Calibri, 30);
    for (int i = 0; i < StringX.size(); i++){
      text(StringX.get(i), 400-textWidth(StringX.get(i)), placeY * (i+3));
    }
    for (int i = 0; i < StringY.size(); i++){
      text(StringY.get(i), placeX * (i+1)+300-textWidth(StringY.get(i))/2, 100);
    }
    
    int i = 0;
    for (int j = 0; j < StringX.size(); j++){
      for (int k = 0; k < StringY.size(); k++){
        text(Data.get(i), placeX * (k+1)+300-textWidth(Data.get(i))/2, placeY * (j+3));
        i++;
      }
    }
    if(Die){
      dead.open();
    }
  }
  
  //draws the results window without changing any numbers and by only using the estimated numbers
  void expectation(){
    BReportExit.show();
    main.hide();
    window = Window.Simulate;
    background(255);
    int WindProd = Wind.AverageProduction * (int)getNr("Wind");
    int WindlProd = Windl.AverageProduction * (int)getNr("Windl");
    int solar = (int)Solar.calcProduction(Month, false);
    int SolarProd = solar * (int)getNr("Solar");
    int SolarlProd = solar * 100 * (int)getNr("Solarl");
    
    float placeY = height/11;
    float placeX = (width - 500)/5;
    StringList StringX = new StringList("nuclear powerplants:", "coal-fired power stations:", "wind turbines:", "photovoltaic:", "households:", "industrial buildings:", "storage plants:", "total:");
    StringList StringY = new StringList("amount:","energy-production:\n         (in kWh)","profit:\n (in $)","CO2-emissions:\n        (in kg)","workers:");
    StringList Data = new StringList(getNr("AKW")+getNr("AKWs")+"", (getNr("AKW")*AKW.Production+getNr("AKWs")*AKWs.Production)+"",(getNr("AKW")*(-AKW.PermanentCost-AKW.Emissions*Tax/1000)+getNr("AKWs")*(-AKWs.PermanentCost-AKWs.Emissions*Tax/1000))+"",(getNr("AKW")*AKW.Emissions+getNr("AKWs")*AKWs.Emissions)+"",(getNr("AKW")*AKW.Happyness+getNr("AKWs")*AKWs.Happyness)+"",
                                     getNr("Coal")+getNr("Coals")+"", (getNr("Coal")*Coal.Production+getNr("Coals")*Coals.Production)+"",(getNr("Coal")*(-Coal.PermanentCost-Coal.Emissions*Tax/1000)+getNr("Coals")*(-Coals.PermanentCost-Coals.Emissions*Tax/1000))+"",(getNr("Coal")*Coal.Emissions+getNr("Coals")*Coals.Emissions)+"",(getNr("Coal")*Coal.Happyness+getNr("Coals")*Coals.Happyness)+"",
                                     getNr("Wind")+getNr("Windl"), (WindProd+WindlProd)+"",(getNr("Wind")*(-Wind.PermanentCost-Wind.Emissions*Tax/1000)+getNr("Windl")*(-Windl.PermanentCost-Windl.Emissions*Tax/1000))+"",(getNr("Wind")*Wind.Emissions+getNr("Windl")*Windl.Emissions)+"",(getNr("Wind")*Wind.Happyness+getNr("Windl")*Windl.Happyness)+"",
                                     getNr("Solar")+getNr("Solarl")+"", (SolarProd+SolarlProd)+"",(getNr("Solar")*(-Solar.PermanentCost-Solar.Emissions*Tax/1000)+getNr("Solarl")*(-Solarl.PermanentCost-Solarl.Emissions*Tax/1000))+"",(getNr("Solar")*Solar.Emissions+getNr("Solarl")*Solarl.Emissions)+"",(getNr("Solar")*Solar.Happyness+getNr("Solarl")*Solarl.Happyness)+"",
                                     getNr("HouseHold")+getNr("HouseHoldl")+"", (getNr("HouseHold")*HH.Production+getNr("HouseHoldl")*HHl.Production)+"",(getNr("HouseHold")*(-HH.PermanentCost-HH.Emissions*Tax/1000)+getNr("HouseHoldl")*(-HHl.PermanentCost-HHl.Emissions*Tax/1000))+"",(getNr("HouseHold")*HH.Emissions+getNr("HouseHoldl")*HHl.Emissions)+"",(getNr("HouseHold")*HH.Happyness+getNr("HouseHoldl")*HHl.Happyness)+"",
                                     getNr("IndustrialBuilding")+getNr("IndustrialBuildingl")+"", (getNr("IndustrialBuilding")*IB.Production+getNr("IndustrialBuildingl")*IBl.Production)+"",(getNr("IndustrialBuilding")*(-IB.PermanentCost-IB.Emissions*Tax/1000)+getNr("IndustrialBuildingl")*(-IBl.PermanentCost-IBl.Emissions*Tax/1000))+"",(getNr("IndustrialBuilding")*IB.Emissions+getNr("IndustrialBuildingl")*IBl.Emissions)+"",(getNr("IndustrialBuilding")*IB.Happyness+getNr("IndustrialBuildingl")*IBl.Happyness)+"",
                                     getNr("PSW")+getNr("PSWs")+"", str(0), (getNr("PSW")*(-PSW.PermanentCost-PSW.Emissions*Tax/1000)+getNr("PSWs")*(-PSWs.PermanentCost-PSWs.Emissions*Tax/1000))+"", (getNr("PSW")*PSW.Emissions+getNr("PSWs")*PSWs.Emissions)+"", (getNr("PSW")*PSW.Happyness+getNr("PSWs")*PSWs.Happyness)+""
                                     );                          
    for (int k = 0; k <= 4; k++){
      int total = 0;      
      for (int i=k; i <= Data.size()-1; i += 5){
        total = total+int(Data.get(i));
      }
      Data.append(str(total));
    }
      
    
    fill(main.Dark);
    stroke(main.Dark);
    strokeWeight(2);
    line(50, height/11*9.5, width-50, height/11*9.5);
    textFont(Calibri, 30);
    for (int i = 0; i < StringX.size(); i++){
      text(StringX.get(i), 400-textWidth(StringX.get(i)), placeY * (i+3));
    }
    for (int i = 0; i < StringY.size(); i++){
      text(StringY.get(i), placeX * (i+1)+300-textWidth(StringY.get(i))/2, 100);
    }
    
    int i = 0;
    for (int j = 0; j < StringX.size(); j++){
      for (int k = 0; k < StringY.size(); k++){
        //int data = int(Data.get(i));
        //if (data>
        text(Data.get(i), placeX * (k+1)+300-textWidth(Data.get(i))/2, placeY * (j+3));
        i++;
      }
    }
    
  }
  
  //checks how many objects of a specific type you have
  long getNr(String object){
    long Number = 0;
    for(int i = Object.size()-1; i >= 0; i--){
      if(object.equals(Object.get(i).Kind) == true){
        Number++;
      }
    }
    return Number;
  }
  
  
  
  
}
