/*----------------------------------------------------------------------
ElectriCity

This window contains all the information about solar panels.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 05.10.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CSolar extends ACEnergyObject{
  
  //number to store the production of the current month 
  float Prod = 0;
  
    CSolar(){
      Image = ImgSolar;
      float Size = 2;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      MoveX = 0.25/7.3*SizeX;
      MoveY = 0.54/7.1*SizeY-main.y;
      Width = 3.5;
      MiddleX = 3.6*2; MiddleYRight = 3.6*2; MiddleYLeft = 9;
      Happyness = 0;
      AverageProduction = 2499;
      PermanentCost = 43;
      InvestmentCost = 34708;
      Emissions = 167;
      Kind = "Solar";
    }
    
  //calculates the production of a solar panel in the current month
  float calcProduction(int month, boolean random){
    switch(month){
      case 1: Prod = 743; break;
      case 2: Prod = 1182; break;
      case 3: Prod = 2336; break;
      case 4: Prod = 3106; break;
      case 5: Prod = 4151; break;
      case 6: Prod = 4454; break;
      case 7: Prod = 4508; break;
      case 8: Prod = 3904; break;
      case 9: Prod = 2722; break;
      case 10: Prod = 1567; break;
      case 11: Prod = 770; break;
      case 12: Prod = 550; break;
      default: break;
    }
    if(random){
      Prod = (Prod+Prod*(random(20)-10)/100.0);
    }
    return Prod;
  }
}

class CSolarbig extends CSolar{
  //number to store the production of the current month 
  float Prod = 0;
  
    CSolarbig(){
      Image = ImgSolar;
      float Size = 4;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      MoveX = 0.25/7.3*SizeX;
      MoveY = 0.54/7.1*SizeY-main.y;
      Width = 3.5*2;
      MiddleX = 3.6*4; MiddleYRight = 3.6*4; MiddleYLeft = 9*2;
      Happyness = 0;
      AverageProduction = 2499*100;
      PermanentCost = 43*100;
      InvestmentCost = 34708*100;
      Emissions = 167*100;
      Kind = "Solarl";
    }
}
