/*----------------------------------------------------------------------
ElectriCity

This class opens the starting window, where you can choose whether you
want to start a new game or continue the last one you saved.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CStart{
  
  //name of the game and text to be written at the top of the starting window
  String Name = "ElectriCity";
  
  //builds the window
  void setup(){
    PFont build = Calibri; 
    ControlFont font = new ControlFont(build, 60);
    cp5Start.setFont(font);
    
    BStartEndless = cp5Start.addButton("BStartNew")
     .setLabel("Start\nnew game")
     .setPosition(width/2+10, height/2)
     .setSize(450,450)
     .hide()
     ;

   BContinue = cp5Start.addButton("BContinue")
     .setLabel("Continue\nlast game")
     .setPosition(width/2-460, height/2)
     .setSize(450,450)
     .hide()
     ;
  }
  
  //shows the buttons and draws the rest of the window
  void open(){
    background(0);
    textFont(Calibri300);
    fill(91,217,35);
    text(Name, width/2-textWidth(Name)/2, 300);
    BStartEndless.show();
    BContinue.show();
  }
  
  //hides the buttons
  void hide(){
    BStartEndless.hide();
    BContinue.hide();
  }
  
}
