/*----------------------------------------------------------------------
ElectriCity

This class opens a window, where you can choose your starting budget
and your emission taxes.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 16.10.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CStartEndless{
  
  //builds the window
  void setup(){
    SEmissionTaxes = cp5Start.addSlider("SEmissionTaxes")
     .setLabel("")
     .setPosition(width/2,600)
     .setWidth(400)
     .setHeight(30)
     .setRange(0,3) 
     .setValue(3)
     .setNumberOfTickMarks(4)
     .setSliderMode(Slider.FLEXIBLE)
     .hide()
     ;
     SEmissionTaxes.getValueLabel().hide();
    
    SBudget = cp5Start.addSlider("SBudget")
     .setPosition(width/2,470)
     .setSize(400,30)
     .setLabel("")
     .setRange(0,2)
     .setValue(1)
     .setNumberOfTickMarks(3)
     .setSliderMode(Slider.FLEXIBLE)
     .hide()
     ;
     SBudget.getValueLabel().hide();
     
    SEmissionTaxes2 = cp5Start.addSlider("SEmissionTaxes2")
     .setLabel("")
     .setPosition(width/2,600)
     .setWidth(400)
     .setHeight(30)
     .setRange(0,3) 
     .setValue(3)
     .setNumberOfTickMarks(4)
     .setSliderMode(Slider.FLEXIBLE)
     .hide()
     ;
     SEmissionTaxes2.getValueLabel().hide();
    
    BOK = cp5Start.addButton("BOK")
    .setLabel("OK")
    .setPosition(width-200, height-90)
    .setSize(170, 60)
    .hide()
    ;
    
    
  }
  
  //shows the controllers and draws the rest of the window
  void open(){
    background(0);
    textFont(Calibri300);
    fill(91,217,35);
    text(start.Name, width/2-textWidth(start.Name)/2, 300);
    textFont(Calibri);
    String text = "choose your budget";
    text(text, width/2-textWidth(text)-100, 500);
    text = "choose your emission taxes";
    text(text, width/2-textWidth(text)-100, 630);
    switch((int)SEmissionTaxes.getValue()){
      case 0: text = "25$/ton (Germany in 2021)"; Tax = 25; break;
      case 1: text = "54$/ton (Germany's goal)"; Tax = 54; break;
      case 2: text = "120$/ton (Switzerland in 2021)"; Tax = 120; break;
      case 3: text = "208$/ton (actual value)"; Tax = 208; break;
      default: break;
    }
    text(text, width/2, 680);
    switch((int)SBudget.getValue()){
      case 0: text = "30 Million $"; Money = 30000000;break;
      case 1: text = "40 Million $"; Money = 40000000;break;
      case 2: text = "50 Million $"; Money = 50000000;break;
      default: break;
    }
    text(text, width/2, 550);
    SEmissionTaxes.show();
    BOK.show();
    SBudget.show();     
  }
  
  //hides the controllers
  void close(){
   SEmissionTaxes.hide(); 
   SEmissionTaxes2.hide();
   BOK.hide();
   SBudget.hide();
  }
  
}
