/*----------------------------------------------------------------------
ElectriCity

This class contains all the information about pumped storage plants.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CStoragePlant extends ACEnergyObject{
  
  CStoragePlant(){
    Image = ImgPSW;
    float Size = 3.8*2;
    SizeX = SizeXMultiplier*Size; //10
    SizeY = SizeYMultiplier*Size;
    MiddleX=14*2; MiddleYRight=20.5*2; MiddleYLeft=21.5*2;
    Width = 3.2*2;
    MoveX = 0*SizeX;
    MoveY = 0.055*SizeY-main.y;
    Happyness = -8;
    Production = 1300000;
    AverageProduction = 1300000;
    PermanentCost = 152100;
    InvestmentCost = 154000000;
    Emissions = 11100;
    Kind = "PSW"; 
  }
}

class CStoragePlantsmall extends CStoragePlant{
  
  CStoragePlantsmall(){
    Image = ImgPSW;
    //falls Multiplikator bei Size gerade: -main.y an MoveY anhängen
    float Size = 3.8;
    SizeX = SizeXMultiplier*Size; //10
    SizeY = SizeYMultiplier*Size;
    MiddleX=14; MiddleYRight=20.5; MiddleYLeft=21.5;
    Width = 3.2;
    MoveX = 0*SizeX;
    MoveY = 0.055*SizeY-main.y;
    Happyness = -1;
    Production = 13000;
    AverageProduction = 13000;
    PermanentCost = 1521;
    InvestmentCost = 1540000;
    Emissions = 110;
    Kind = "PSWs"; 
  }  
}
