/*----------------------------------------------------------------------
ElectriCity

This class contains all the information about wind turbines.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CWind extends ACEnergyObject{
  
  //stores the production of the current month
  int Prod = 0;
  
  CWind(){
      Image = ImgWind; 
      float Size = 1.7*3;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      MoveX = -0.43;
      MoveY = 0.38;
      MiddleX = 18.2; MiddleYRight = MiddleYLeft = 28.4;
      Width = 1;
      Happyness = 0;
      calcProduction();
      Production = calcProduction();
      AverageProduction = 183000;
      PermanentCost = 45458;
      InvestmentCost = 2273000;
      Emissions = 3203;
      Kind = "Wind";
  }
  
  //calculates the production of this month by using a random number and the probaility of each production
  int calcProduction(){
    float random = random(100);
    if(random <= 5.3){
      Prod = 0;
    }
    else if(random <= 14.5){
      Prod = 1000;
    }
    else if(random <= 26.2){
      Prod = 9000;
    }
    else if(random <= 39){
      Prod = 30000;
    }
    else if(random <= 51.6){
      Prod = 64000;
    }
    else if(random <= 63.1){
      Prod = 119000;
    }
    else if(random <= 73){
      Prod = 196000;
    }
    else if(random <= 81){
      Prod = 299000;
    }
    else if(random <= 87.1){
      Prod = 429000;
    }
    else if(random <= 91.5){
      Prod = 575000;
    }
    else if(random <= 94.6){
      Prod = 696000;
    }
    else if(random <= 96.6){
      Prod = 776000;
    }
    else if(random <= 97.9){
      Prod = 825000;
    }
    else if(random <= 98.7){
      Prod = 861000;
    }
    else if(random <= 99.1){
      Prod = 867000;
    }
    else if(random <= 99.3){
      Prod = 868000;
    }
    else if(random <= 99.4){
      Prod = 869000;
    }
    else if(random <= 99.5){
      Prod = 869000;
    }
    return Prod;
  }
}

class CWindbig extends CWind{
  
  //stores the production of the current month
  int Prod = 0;
  
  CWindbig(){
      Image = ImgWind; 
      float Size = 1.7*6;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      MoveX = -0.43*2;
      MoveY = 0.38*2;
      MiddleX = 18.2*2; MiddleYRight = MiddleYLeft = 28.4*2;
      Width = 1*2;
      Happyness = 0;
      calcProduction();
      Production = calcProduction();
      AverageProduction = 183000*10;
      PermanentCost = 45458*10;
      InvestmentCost = 2273000*10;
      Emissions = 3203*10;
      Kind = "Windl";
    }
}
