import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import controlP5.*; 
import java.awt.*; 
import java.awt.event.WindowEvent; 
import com.jogamp.newt.opengl.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class ElectriCity3 extends PApplet {

/*----------------------------------------------------------------------
ElectriCity

This is the main class of the project. 
It controls all the buttons and mousePressed, mouseWheel controls etc.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 16.10.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

//Buttons and Textfields


//to close only one window




//one object of each class
CMain main = new CMain();
CBuild build = new CBuild();
CDetails details = new CDetails();
CReport report = new CReport();
CAKW AKW = new CAKW();
CAKWsmall AKWs = new CAKWsmall();
CCoal Coal = new CCoal();
CCoalsmall Coals = new CCoalsmall();
CSolar Solar = new CSolar();
CSolarbig Solarl = new CSolarbig();
CWind Wind = new CWind();
CWindbig Windl = new CWindbig();
CHousehold HH = new CHousehold();
CHouseholdbig HHl = new CHouseholdbig();
CIndustrialBuilding IB = new CIndustrialBuilding();
CIndustrialBuildingbig IBl = new CIndustrialBuildingbig();
CStart start = new CStart();
CStartEndless startEndless = new CStartEndless();
CEmissionTaxes Taxes = new CEmissionTaxes();
CMenu Menu = new CMenu();
CDead dead = new CDead();
ACEnergyObject Objects2 = new ACEnergyObject();
CChoose choose = new CChoose();
CStoragePlant PSW = new CStoragePlant();
CStoragePlantsmall PSWs = new CStoragePlantsmall();
CSimulation Simulation = new CSimulation();

//checks if the background is grabbed (and can be moved) or not
boolean Grabbed = false;
//Images of the Objects
PImage ImgAKW;
PImage ImgCoal;
PImage ImgPSW;
PImage ImgSolar;
PImage ImgWind;
PImage ImgHH;
PImage ImgIB;

//groups of buttons
ControlP5 cp5Main;
ControlP5 cp5Build;
ControlP5 cp5Details;
ControlP5 cp5Report;
ControlP5 cp5Start;

//Buttons CBuild
controlP5.Button BBuildAKW;
controlP5.Button BBuildCoal;
controlP5.Button BBuildPSW;
controlP5.Button BBuildWind;
controlP5.Button BBuildPV;
controlP5.Button BBuildHH;
controlP5.Button BBuildIB;
controlP5.Button BDetailsAKW;
controlP5.Button BDetailsCoal;
controlP5.Button BDetailsPSW;
controlP5.Button BDetailsWind;
controlP5.Button BDetailsPV;
controlP5.Button BDetailsHH;
controlP5.Button BDetailsIB;
controlP5.Button BBuildExit;

//Buttons cDetails
controlP5.Button BDetailsExit;

//Buttons CReport
controlP5.Button BReportExit;

//Buttons CStart
controlP5.Button BStartEndless;
controlP5.Button BContinue;

//Buttons CMain
controlP5.Button BBuild;
controlP5.Button BSimulate;
controlP5.Button BExpectation;
controlP5.Button BExit;
controlP5.Slider SZoom;

//Labels CMain
controlP5.Button LMonth;
controlP5.Button LWorkers;
controlP5.Button LMoney;
controlP5.Button LEnergy;
controlP5.Button LCO2;
controlP5.Button LYear;

//Buttons CChoose
controlP5.Button BLarge;
controlP5.Button BSmall;
controlP5.Button BChooseExit;


//Slider CStartEndless
controlP5.Slider SEmissionTaxes;
controlP5.Slider SEmissionTaxes2;
controlP5.Slider SBudget;

//Button CStartEndless
controlP5.Button BOK;

//Textfield/Button CSimulation
controlP5.Textfield TSimulation;
controlP5.Button BSimulation;

//array list to store the objects
ArrayList<ACEnergyObject> Object = new ArrayList<ACEnergyObject>();

//stores the object which is being built
ACEnergyObject BuildingObject;
//stores the Object whose details are being shown
ACEnergyObject Objects;

//Fonts
PFont Calibri;
PFont Calibri300;

//information needed to display CDetails
String DetailsTitle;
String DetailsTitle2;
PImage DetailsImage;

//general data, displayed in window main
int Month = 1;
int Year = 0;
long Money = 0;
long Energy = 0;
long CO2 = 0;
int Workers=0;

//the amount, one ton of CO2 costs
int Tax = 208;
//the duration of the simulation
int Duration = 0;

//checks if expectation or simulation is called
boolean Simulate = false;

//checks if the tutorial needs to be played (only the first time opening the game)
boolean First = false;

//checks if the tutorial is beeing played
boolean Tutorial = false;

//checks if the taxes window needs to be opened again if its closed 
boolean Taxe = false;

//checks which step of the tutorial needs to be shown
int Step = 0;

//checks which window is currently opened
enum Window {
  Start, Main, Build, Building, Simulate, Details, Dead, Taxes, Simulation
}
Window window = Window.Start;

//decides the size
public void settings(){
 fullScreen();
}

//loads the images, creates the windows, sets First to true if it,s the first time the game is opened
public void setup() {
  cp5Start = new ControlP5(this);
  Calibri = loadFont("Calibri.vlw");
  Calibri300 = loadFont("Calibri-300.vlw");
  start.setup();
  start.open();
  ImgAKW = loadImage("ImgNuclear.png");
  ImgCoal = loadImage("ImgCoal.png");
  ImgPSW =loadImage("ImgPSW.png");
  ImgSolar = loadImage("ImgPV30G.png");
  ImgWind = loadImage("ImgWind.png");
  ImgHH = loadImage("ImgHH.png");
  ImgIB = loadImage("ImgIB.png");
  cp5Main = new ControlP5(this);
  cp5Build = new ControlP5(this);
  cp5Details = new ControlP5(this);
  cp5Report = new ControlP5(this);
  main.setup();
  build.setup();
  details.setup();
  report.setup();
  startEndless.setup();
  choose.setup();
  runSketch(new String[]{"CEmissionTaxes"}, Taxes);
  Taxes.setup();
  Simulation.setup();
  String[] first = loadStrings("data/First.txt");
  if(first[0].equals("0")){
    First = true;
  }
}

// everything that has to be checked each frame and hasn't got it's own method for checking, tutorial
public void draw() {
  if(Money < 0){
    dead.Reason = " because you ran out of money.";
    main.hide();
    dead.open();
  }
  switch(window){
    case Main:
      // checks if the background is grabbed and if so calls the method to move it
      if (main.Grabbed == true) {
        main.move();
      }
      break;
    case Building:
      BuildingObject.move();
      break;
    default: break;
  }
  if(First && Tutorial){
        switch(Step){
          case 0:  
            textFont(Calibri);
            arrow(width-600, height-330, width-400,height-130, -1, 1); 
            noStroke();
            fill(255);
            rect(width-910, height-340, textWidth("press build to build objects")+20, -50);
            fill(0);
            text("press build to build objects", width-900, height-350); 
            break;
          
          case 1:
            textFont(Calibri);
            arrow(build.SpaceXC+400, 3*build.SpaceY+400, build.SpaceXC + 250,3*build.SpaceY+600, 1, 1); 
            noStroke();
            fill(255);
            rect(build.SpaceXC+100, 3*build.SpaceY+300, textWidth("see the information about households")+20, -50);
            fill(0);
            text("see the information about households", build.SpaceXC+100, 3*build.SpaceY+300); 
            break;
            
          case 2:
            textFont(Calibri);
            arrow(300, 300, 100, 100, 1, -1); 
            noStroke();
            fill(255);
            rect(250, 380, textWidth("go back")+20, -50);
            fill(0);
            text("go back", 250, 380); 
            break;
            
          case 3:
            textFont(Calibri);
            arrow(build.SpaceXC+300, 3*build.SpaceY+300, build.SpaceXC+200, 3*build.SpaceY+400, 1, 1); 
            noStroke();
            fill(255);
            rect(build.SpaceXC+150, 3*build.SpaceY+250, textWidth("build a house")+20, -50);
            fill(0);
            text("build a house", build.SpaceXC+150, 3*build.SpaceY+250); 
            break;   
            
          case 4:
            textFont(Calibri);
            fill(255);
            rect(build.SpaceXC+140, 3*build.SpaceY+260, textWidth("click to place it")+20, -50);
            fill(0);
            text("click to place it", build.SpaceXC+150, 3*build.SpaceY+250); 
            break;
            
          case 5:
            textFont(Calibri);
            arrow(width-800, height-330, width-600,height-130, -1, 1); 
            noStroke();
            fill(255);
            rect(build.SpaceXC-60, 3*build.SpaceY+460, textWidth("press expectation to see the expected results of a simulation")+20, -50);
            fill(0);
            text("press expectation to see the expected results of a simulation", build.SpaceXC-50, 3*build.SpaceY+450); 
            break; 
            
          case 6:
            textFont(Calibri);
            noStroke();
            fill(255);
            rect(width/2-textWidth("if more energy is used, than produced, you lose")/2-10, height/2+10, textWidth("if more energy is used, than produced, you lose")+20, -50);
            fill(0);
            text("if more energy is used, than produced, you lose", width/2-textWidth("if more energy is used, than produced, you lose")/2, height/2); 
            break; 
            
          case 7:
            textFont(Calibri);
            noStroke();
            fill(255);
            rect(width/2-textWidth("if your money runs out, you lose")/2-10, height/2+10, textWidth("if your money runs out, you lose")+20, -50);
            fill(0);
            text("if your money runs out, you lose", width/2-textWidth("if your money runs out, you lose")/2, height/2); 
            break;
            
          default: break;
        }
      }
}
//buttons CMain
//opens the build window when BBuild is pressed
public void BBuild() {
  if(window != Window.Taxes){
    window = Window.Build;
    main.hide();
    build.display();
    if(Step == 0){
     Step = 1; 
    }
  }
}
//opens the window to enter the simulation duration when BSimulate is pressed
public void BSimulate(){
  if(window != Window.Taxes){
    Simulate = true;
    Simulation.open();
    window = Window.Simulate;
    main.hide();
  }
}
//opens the expextation when BExpectation is pressed
public void BExpectation(){
  if(window != Window.Taxes){
    Simulate = false;
    report.expectation();
    if(Step == 5){
      Step = 6;
    }
  }
}
//opens the menu when BMenu is pressed
public void BExit(){
  runSketch(new String[]{"CMenu"}, Menu);
}
//zooms when SZoom is moved
public void SZoom() {
  try{
    if(window != Window.Taxes){
      if(SZoom.isMouseOver()){
        float posX = main.PosX/main.Zoom;
        float posY = main.PosY/main.Zoom;
        main.Zoom = SZoom.getValue();
        main.PosX = posX*main.Zoom;
        main.PosY = posY*main.Zoom;
        main.display();
      }
    }
  } catch (NullPointerException e){
  }
}
//buttons CChoose
//goes back to build choose when BChooseExit is pressed
public void BChooseExit(){
  choose.hide();
  build.display();
}
//builds the large version of an object
public void BLarge(){
  fill(main.Dark);
  textFont(Calibri);
  switch(choose.type){
    case 0: 
      if(Money > AKW.InvestmentCost){
        if(Workers >= 5000){
          Workers -= 5000;
          CAKW AKW = new CAKW();
          Object.add(AKW);
          BuildingObject = AKW;
          AKW.build();
          choose.hide();
       }else{
          choose.hide();
          build.display();
          text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
        }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
    
    case 1:
      if(Money > Coal.InvestmentCost){
        if(Workers >= 1380){
          Workers -= 1380;
          CCoal Coal = new CCoal();
          Object.add(Coal);
          BuildingObject = Coal;
          Coal.build();
          choose.hide();
       }else{
          choose.hide();
          build.display();
          text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
        }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
    case 2:
      CWindbig Windl = new CWindbig();
      if(Money > Windl.InvestmentCost){
        BuildingObject = Windl;
        Object.add(Windl);
        Windl.build();
        choose.hide();
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
    case 3:
      CSolarbig Solarl = new CSolarbig();
      if(Money > Solarl.InvestmentCost){
        BuildingObject = Solarl;
        Object.add(Solarl);
        Solarl.build();
        choose.hide();
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
    case 4:
      CHouseholdbig HHl = new CHouseholdbig();
      if(Money > HHl.InvestmentCost){
        Object.add(HHl);
        BuildingObject = HHl;
        HHl.build();
        Workers += 650;
        if(Step == 3){
          Step = 4;
        }
        choose.hide();
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
     case 5:
       CIndustrialBuildingbig IBl = new CIndustrialBuildingbig();
       if(Money > IBl.InvestmentCost){
         if(Workers >= 1000){
            Workers -= 1000;
            Object.add(IBl);
            BuildingObject = IBl;
            IBl.build();
            choose.hide();
         }else{
            choose.hide();
            build.display();
            text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
          }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }  
      break;
      
    case 6:
      CStoragePlant PSW = new CStoragePlant();
      if(Money > PSW.InvestmentCost){
         if(Workers >= 8){
            Workers -= 8;
            Object.add(PSW);
            BuildingObject = PSW;
            PSW.build();
            choose.hide();
         }else{
            choose.hide();
            build.display();
            text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
          }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
    default: break;
  }
}

//builds the small version of an object
public void BSmall(){
  fill(main.Dark);
  textFont(Calibri);
  switch(choose.type){
    case 0: 
      CAKWsmall AKWs = new CAKWsmall();
      if(Money > AKWs.InvestmentCost){
        if(Workers >= 50){
          Workers -= 50;
          Object.add(AKWs);
          BuildingObject = AKWs;
          AKWs.build();
          choose.hide();
        }else{
          choose.hide();
          build.display();
          text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
        }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
    
    case 1: 
      CCoalsmall Coals = new CCoalsmall();
      if(Money > Coals.InvestmentCost){
        if(Workers >= 14){
          Workers -= 14;
          Object.add(Coals);
          BuildingObject = Coals;
          Coals.build();
          choose.hide();
        }else{
          choose.hide();
          build.display();
          text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
        }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
    case 2: 
      if(Money > Wind.InvestmentCost){
        CWind Wind = new CWind();
        BuildingObject = Wind;
        Object.add(Wind);
        Wind.build();
        choose.hide();
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
    case 3:
      if(Money > Solar.InvestmentCost){
        CSolar Solar = new CSolar();
        BuildingObject = Solar;
        Object.add(Solar);
        Solar.build();
        choose.hide();
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
    case 4: 
      if(Money > HH.InvestmentCost){
        CHousehold Household = new CHousehold();
        Object.add(Household);
        BuildingObject = Household;
        Household.build();
        Workers += 65;
        if(Step == 3){
          Step = 4;
        }
        choose.hide();
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
    case 5:
      if(Money > IB.InvestmentCost){
        if (Workers >= 100){
          Workers -= 100;
          CIndustrialBuilding IB = new CIndustrialBuilding();
          Object.add(IB);
          BuildingObject = IB;
          IB.build();
          choose.hide();
        }else{
          choose.hide();
          build.display();
          text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
        }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
    case 6:
      CStoragePlantsmall PSW = new CStoragePlantsmall();
      if(Money > PSW.InvestmentCost){
         if(Workers >= 1){
            Workers -= 1;
            Object.add(PSW);
            BuildingObject = PSW;
            PSW.build();
            choose.hide();
         }else{
            choose.hide();
            build.display();
            text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
          }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }  
    default: break;
  }
}

//buttons CBuild
//exit
public void BBuildExit(){
  build.hide();
  main.display();
  window = Window.Main;
}
//opens the window where you can choose the size
public void BBuildAKW(){
  choose.type = 0;
  build.hide();
  choose.show();
}
//opens the window where you can choose the size
public void BBuildCoal(){
  choose.type = 1;
  build.hide();
  choose.show();
}
//opens the window where you can choose the size
public void BBuildWind(){
  choose.type = 2;
  build.hide();
  choose.show();
}
//opens the window where you can choose the size
public void BBuildPV(){
  choose.type = 3;
  build.hide();
  choose.show();
}
//opens the window where you can choose the size
public void BBuildHH(){
  choose.type = 4;
  build.hide();
  choose.show();
}
//opens the window where you can choose the size
public void BBuildIB(){
  choose.type = 5;
  build.hide();
  choose.show();
}
//opens the window where you can choose the size
public void BBuildPSW(){
  choose.type = 6;
  build.hide();
  choose.show();
}


//details buttons
//opens the details window, tells it which object has to be explained and gives the information abou the license of the image
public void BDetailsAKW(){
  build.hide();
  Objects = AKW;
  CAKWsmall AKWs = new CAKWsmall();
  Objects2 = AKWs;
  DetailsImage = loadImage("ImgCompare.jpg");
  DetailsTitle = "nuclear power plant";
  DetailsTitle2 = "small version";
  details.ImageName = "Nuclear Powerplant Low-poly ";
  details.ImageCreator = "Scilence ";
  details.LinkImage = "https://sketchfab.com/3d-models/nuclear-powerplant-low-poly-44100dd4134b40a1a8bb6a0490a2d83d";
  details.LinkCreator = "https://sketchfab.com/Scilence";
  window = Window.Details;
  details.display();
 
  fill(0,0,0);
  textFont(Calibri, 40);
  text("total cost in million", 40, 380);
  text("month", (40+width/2+160)/2-textWidth("month")/2, height-40);
  
  fill(0,80,0);
  text("compared to other power plants:", 40, 330);
  
  fill(255, 127, 0);
  text("coal", width/2+300, 350+(height-500)/4*4-40);
  fill(255, 182, 193);
  text("nuclear", width/2+300, 350+(height-500)/4-40);
  fill(0,0,255);
  text("wind", width/2+300, 350+(height-500)/4*2-40);
  fill(255,0,0);
  text("solar", width/2+300, 350+(height-500)/4*3-40);
  
  textFont(Calibri, 20);

}
//opens the details window, tells it which object has to be explained and gives the information abou the license of the image
public void BDetailsCoal(){
  build.hide();
  Objects = Coal;
  CCoalsmall Coals = new CCoalsmall();
  Objects2 = Coals;
  DetailsImage = loadImage("ImgCompare.jpg");
  DetailsTitle = "coal-fired power station";
  DetailsTitle2 = "small version";
  details.ImageName = "Low Poly Coal Plant stylized - animated ";
  details.ImageCreator = "ClimateHackerz ";
  details.LinkImage = "https://sketchfab.com/3d-models/low-poly-coal-plant-stylized-animated-38d9172a0e1740289e29f26143e4b594";
  details.LinkCreator = "https://sketchfab.com/ClimateHackerz";
  window = Window.Details;
  details.display();

  fill(0,0,0);
  textFont(Calibri, 40);
  text("total cost in million", 40, 380);
  text("month", (40+width/2+160)/2-textWidth("month")/2, height-40);
  
  fill(0,80,0);
  text("compared to other power plants:", 40, 330);
  
  fill(255, 127, 0);
  text("coal", width/2+300, 350+(height-500)/4*4-40);
  fill(255, 182, 193);
  text("nuclear", width/2+300, 350+(height-500)/4-40);
  fill(0,0,255);
  text("wind", width/2+300, 350+(height-500)/4*2-40);
  fill(255,0,0);
  text("solar", width/2+300, 350+(height-500)/4*3-40);
  
  textFont(Calibri, 20);

}
//opens the details window, tells it which object has to be explained and gives the information abou the license of the image
public void BDetailsWind(){
  build.hide();
  Objects = Wind;
  CWindbig Windl = new CWindbig();
  Objects2 = Windl;
  DetailsImage = loadImage("ImgDetailsWind2.jpg");
  DetailsTitle = "wind turbine";
  DetailsTitle2 = "large version";
  details.ImageName = "Wind Turbine ";
  details.ImageCreator = "DoobiDooba ";
  details.LinkImage = "https://sketchfab.com/3d-models/wind-turbine-285032402a8543ae8bf3e3c4d8c9f98a";
  details.LinkCreator = "https://sketchfab.com/DoobiDooba";
  window = Window.Details;
  details.display();
}
//opens the details window, tells it which object has to be explained and gives the information abou the license of the image
public void BDetailsPV(){
  build.hide();
  Objects = Solar;
  CSolarbig Solarl = new CSolarbig();
  Objects2 = Solarl;
  DetailsImage = loadImage("ImgDetailsSolar4.png");
  DetailsTitle = "solar panel";
  DetailsTitle2 = "large version";
  details.ImageName = "soler panel setup ";
  details.ImageCreator = "kking88gb ";
  details.LinkImage = "https://sketchfab.com/3d-models/soler-panel-setup-087f976a313f401da2d38f0df73905ff";
  details.LinkCreator = "https://sketchfab.com/kking88gb";
  window = Window.Details;
  details.display();
}
//opens the details window, tells it which object has to be explained and gives the information abou the license of the image
public void BDetailsHH(){
  build.hide();
  Objects = HH;
  CHouseholdbig HHl = new CHouseholdbig();
  Objects2 = HHl;
  DetailsImage = ImgHH;
  DetailsTitle = "Household";
  DetailsTitle2 = "large version";
  details.ImageName = "European House #1 ";
  details.ImageCreator = "Satik64 ";
  details.LinkImage = "https://sketchfab.com/3d-models/european-house-1-a81c9bcf068f47ccb737bead5fac3e0d";
  details.LinkCreator = "https://sketchfab.com/Satik64";
  window = Window.Details;
  details.display();
  if(Step == 1){
    Step = 2; 
  }
}
//opens the details window, tells it which object has to be explained and gives the information abou the license of the image
public void BDetailsIB(){
  build.hide();
  Objects = IB;
  CIndustrialBuildingbig IBl = new CIndustrialBuildingbig();
  Objects2 = IBl;
  DetailsImage = ImgIB;
  DetailsTitle = "industrial building";
  DetailsTitle2 = "large version";
  details.ImageName = "Victorian Factory ";
  details.ImageCreator = "Paolo Mercogliano ";
  details.LinkImage = "https://sketchfab.com/3d-models/victorian-factory-961eb80bb017465a8a900fb0bd0e8404";
  details.LinkCreator = "https://sketchfab.com/paolo.mercoglia";
  window = Window.Details;
  details.display();
}
//opens the details window, tells it which object has to be explained and gives the information abou the license of the image
public void BDetailsPSW(){
  build.hide();
  Objects = PSW;
  Objects2 = PSWs;
  DetailsImage = ImgPSW;
  DetailsTitle = "storage plant";
  DetailsTitle2 = "small version";
  details.ImageName = "Snowy Water tank ";
  details.ImageCreator = "Polygon Experts ";
  details.LinkImage = "https://sketchfab.com/3d-models/snowy-water-tank-b9cf4603062b4b93b10cb83e07ac596b";
  details.LinkCreator = "https://sketchfab.com/polygonexperts";
  window = Window.Details;
  details.display();
  fill(main.Dark);
  textFont(Calibri, 40);
  text("this doesn't produce electricity. It stores it.", 40, 380);
}

//button CDetails (go back to build)
public void BDetailsExit(){
  details.hide();
  build.display();
  window = Window.Build;
  if(Step == 2){
    Step = 3; 
  }
}

//buttons CReport
//closes the report and, if it was a simulation, opens the window to pay taxes
public void BReportExit(){
  report.hide();
  if(Simulate){
    main.display();
    Taxes.open();
    window = Window.Taxes;
  } else{
    main.display();
    window = Window.Main;
  }
  if(Step == 6){
    Step = 7; 
  }
}

//buttons CStart
//starts a new game
public void BStartNew(){
  start.hide();
  startEndless.open();
}
//loads the objects and data from the last stored game and continues it
public void BContinue(){
  try{
    String[] objects = loadStrings("data/Object.txt");
    for(int i = 0; i < objects.length; i++){
      String[] object = split(objects[i], ' ');
      switch(object[0]){
       case "AKW": CAKW AKW = new CAKW(); AKW.ShiftX = Float.parseFloat(object[1]); AKW.ShiftY = Float.parseFloat(object[2]); Object.add(AKW);break;
       case "AKWs": CAKWsmall AKWs = new CAKWsmall(); AKWs.ShiftX = Float.parseFloat(object[1]); AKWs.ShiftY = Float.parseFloat(object[2]); Object.add(AKWs);break;
       case "Coal": CCoal Coal = new CCoal(); Coal.ShiftX = Float.parseFloat(object[1]); Coal.ShiftY = Float.parseFloat(object[2]); Object.add(Coal);break;
       case "Coals": CCoalsmall Coals = new CCoalsmall(); Coals.ShiftX = Float.parseFloat(object[1]); Coals.ShiftY = Float.parseFloat(object[2]); Object.add(Coals);break;
       case "HouseHold": CHousehold HH = new CHousehold(); HH.ShiftX = Float.parseFloat(object[1]); HH.ShiftY = Float.parseFloat(object[2]); Object.add(HH);break;
       case "HouseHoldl": CHouseholdbig HHl = new CHouseholdbig(); HHl.ShiftX = Float.parseFloat(object[1]); HHl.ShiftY = Float.parseFloat(object[2]); Object.add(HHl);break;
       case "IndustrialBuilding": CIndustrialBuilding IB = new CIndustrialBuilding(); IB.ShiftX = Float.parseFloat(object[1]); IB.ShiftY = Float.parseFloat(object[2]); Object.add(IB);break;
       case "IndustrialBuildingl": CIndustrialBuildingbig IBl = new CIndustrialBuildingbig(); IBl.ShiftX = Float.parseFloat(object[1]); IBl.ShiftY = Float.parseFloat(object[2]); Object.add(IBl);break;
       case "Solar": CSolar PV = new CSolar(); PV.ShiftX = Float.parseFloat(object[1]); PV.ShiftY = Float.parseFloat(object[2]); Object.add(PV);break;
       case "Solarl": CSolarbig PVl = new CSolarbig(); PVl.ShiftX = Float.parseFloat(object[1]); PVl.ShiftY = Float.parseFloat(object[2]); Object.add(PVl);break;
       case "Wind": CWind Wind = new CWind(); Wind.ShiftX = Float.parseFloat(object[1]); Wind.ShiftY = Float.parseFloat(object[2]); Object.add(Wind);break;
       case "Windl": CWindbig Windl = new CWindbig(); Windl.ShiftX = Float.parseFloat(object[1]); Windl.ShiftY = Float.parseFloat(object[2]); Object.add(Windl);break;
       case "PSW": CStoragePlant PSW = new CStoragePlant(); PSW.ShiftX =  Float.parseFloat(object[1]); PSW.ShiftY = Float.parseFloat(object[2]); Object.add(PSW);break;
       case "PSWs": CStoragePlantsmall PSWs = new CStoragePlantsmall(); PSWs.ShiftX =  Float.parseFloat(object[1]); PSWs.ShiftY = Float.parseFloat(object[2]); Object.add(PSWs);break;
       default: break;
      }
    }
  } catch (ArrayIndexOutOfBoundsException e){
  }

  try{
    String[] data = loadStrings("data/Data.txt");
    Month = Integer.parseInt(data[0]);
    Money = Math.round(Double.parseDouble(data[1]));
    Energy = Math.round(Double.parseDouble(data[2]));
    CO2 = Math.round(Double.parseDouble(data[3]));
    Tax = Integer.parseInt(data[5]);
    Workers = Integer.parseInt(data[6]);
    Taxe = Boolean.parseBoolean(data[7]);
    Year = Integer.parseInt(data[8]);
    main.display();
    //opens the taxes window if necessairy
    if(Taxe){
       Taxes.open();
       window = Window.Taxes;
    } else {
      window = Window.Main;
    }
    start.hide();
  } catch (ArrayIndexOutOfBoundsException e){
  }
}

//buttons and sliders CStartEndless
//closes and reopens the window when the slider is moved (to reload the text)
public void SEmissionTaxes(){
  try{
    startEndless.close();
    startEndless.open();
  } catch (NullPointerException e){
  } 
}

//starts the game if the budget is a number and within the accepted range
public void BOK(){
  main.display();
  startEndless.close();
  window = Window.Main;
  Tutorial = true;
}
//closes and reopens the window when the slider is moved (to reload the text)
public void SBudget(){
  try{
    SEmissionTaxes2.setValue(SEmissionTaxes.getValue());
    startEndless.close();
    SEmissionTaxes2.show();
    startEndless.open();
  } catch (NullPointerException e){
  }
}
//checks if the entered duration is acceptable and starts the simulation
public void BSimulation(){
  if(TSimulation.getText().trim().length() > 9){
    TSimulation.setColor(color(255,0,0));
    TSimulation.setText("number is too big");
  } else {
    try {
      Duration = Integer.parseInt(TSimulation.getText());
      if(Duration < 1){
        TSimulation.setColor(color(255,0,0));
        TSimulation.setText("number is too small");
      }else{
        report.simulate();
        Simulation.hide();
      }
    } catch (NumberFormatException e) {
      TSimulation.setColor(color(255,0,0));
      TSimulation.setText("not an integer");
    }
  }
}

//called when the mouse is pressed...
public void mousePressed() {
  SEmissionTaxes2.hide();
  if(Step == 4){
    Step = 5;
  }
  if(Step == 7){
    Tutorial = false;
    String[] first = new String[1];
    first[0] = "1";
    saveStrings("data/First.txt", first);
    Step = 8;
  }
  switch(window) {
  case Dead: 
    Object = new ArrayList<ACEnergyObject>();
    Month = 1;
    Year = 0;
    Money = 0;
    Energy = 0;
    CO2 = 0;
    Workers = 0;
    start.open(); 
    window=Window.Start; 
    break;
  
  //...on the window "Main"
  case Main:  
    main.Grabbed = true;
    break;
    
  //...while building a new object
  case Building:
    if(BuildingObject.ground()){
      BuildingObject.place();
      window = Window.Main;
    }
    break;
  
  //...on the window "Taxes"
  case Taxes: Taxes.hide(); Taxes.open();break;
    
  //...on the window "Details"
  case Details:
    if(mouseX > width-30-textWidth(details.ImageName)-textWidth(details.By)-textWidth(details.ImageCreator)-textWidth(details.Licensed)-textWidth(details.Attribution) && mouseX < width-30-textWidth(details.By)-textWidth(details.ImageCreator)-textWidth(details.Licensed)-textWidth(details.Attribution) && mouseY > height-60 && mouseY < height-20){
       link(details.LinkImage); 
    } else if(mouseX > width-30-textWidth(details.ImageCreator)-textWidth(details.Licensed)-textWidth(details.Attribution) && mouseX < width-30-textWidth(details.Licensed)-textWidth(details.Attribution) && mouseY > height-60 && mouseY < height-20){
       link(details.LinkCreator); 
    } else if(mouseX > width-30-textWidth(details.Attribution) && mouseX < width-30 && mouseY > height-60 && mouseY < height-20){
       link("https://creativecommons.org/licenses/by/4.0/"); 
    }
  default: break;
  }
}

//called when the mouse is released...
public void mouseReleased() {
  switch(window) {
    
  //...on the window "Main"
  case Main:  
    main.Grabbed = false;
    break;
  default: break;
  }
}

//called when the MouseWheel is turned
public void mouseWheel(MouseEvent event) {
  if(window == Window.Main){
    float e = event.getCount();
    if(main.Zoom-5*e <= 3){
      float posX = main.PosX/main.Zoom;
      float posY = main.PosY/main.Zoom;
      main.Zoom = 3;
      main.PosX = posX*main.Zoom;
      main.PosY = posY*main.Zoom;
    }else if(main.Zoom-5*e > 3 && main.Zoom-5*e < 90){
      float posX = main.PosX/main.Zoom;
      float posY = main.PosY/main.Zoom;
      main.Zoom = main.Zoom-5*e;
      main.PosX = posX*main.Zoom;
      main.PosY = posY*main.Zoom;
    }else if(main.Zoom-5*e >= 90){
      float posX = main.PosX/main.Zoom;
      float posY = main.PosY/main.Zoom;
      main.Zoom = 90;
      main.PosX = posX*main.Zoom;
      main.PosY = posY*main.Zoom;
    }
    SZoom.setValue(main.Zoom);
    main.display();
  }
}

//saves the objects and data in text documents
public void save2(){
  StringList objectstxt = new StringList();
    for (int i = 0; i < Object.size(); i++){
      ACEnergyObject object = Object.get(i);
      objectstxt.append(object.Kind+" "+Float.toString(object.ShiftX)+" "+Float.toString(object.ShiftY));
    }
    String[] array = objectstxt.array();
    saveStrings("data/Object.txt", array);
    String[] Data = new String[9];
    Data[0] = str(Month);
    Data[1] = str(Money);
    Data[2] = str(Energy);
    Data[3] = str(CO2);
    Data[5] = str(Tax);
    Data[6] = str(Workers);
    Data[7] = str(Taxe);
    Data[8] = str(Year);
    saveStrings("data/Data.txt", Data);
}
//draws an arrow
public void arrow(int startx, int starty, int endx, int endy, int right, int down){
  stroke(0);
  strokeWeight(10);
  line(startx, starty, endx, endy);
  line(endx, endy-20*down, endx, endy);
  line(endx+20*right, endy, endx, endy);
}
//called from outside the main window to close the application
public void close2(){
  exit(); 
}
/*----------------------------------------------------------------------
ElectriCity

This class is the superclass for every object. 
It contains the member variables and the methods.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class ACEnergyObject{
  //x-coordinate, y-coordinate, width of an object
  float Posx; float Posy; float Width;
  
  //the distance of an object to the screens centre (multiplied by zoom for the real distance)
  float ShiftX; float ShiftY;
  
  //describes how far the corner of the object has to be moved away from the field in order to be placed correctly on it
  float MoveX; float MoveY;
  
  //appearance of the object
  PImage Image;
  
  //Size of the object (multiplied by zoom for the real size) 
  float SizeX; float SizeY; 
  
  //defines the ratio between SizeX and SizeY
  float SizeXMultiplier = 7.3f; float SizeYMultiplier = 7.1f;
  
  //the x-coordinate of the point in the middle of the object
  float MiddleX; 
  
  //y-coordinate of the right and the left corner
  float MiddleYRight; float MiddleYLeft;
  
  //defines what kind of object it is (for example "AKW")
  String Kind;
  
  //should have been the effect on the populations happyness, changed to number of workers in the end (10 workers resemble 1)
  int Happyness;
  
  //in kWh/month
  int Production;
  
  //in kWh/month
  int AverageProduction;
  
  //in swiss Francs/month
  int PermanentCost;
  
  //in swiss Francs
  long InvestmentCost;
  
  //in kg/month
  int Emissions;
  
  //draws every object
  public void display(){
    Posx = ShiftX*main.Zoom+width/2.0f;
    Posy = ShiftY*main.Zoom+height/2.0f;
    image(Image, Posx, Posy, SizeX*main.Zoom, SizeY*main.Zoom);
  }
  
  //moves the object
  public void move(){
    Posx = mouseX-(SizeX*main.Zoom)/2.0f;
    Posy = mouseY-(SizeY*main.Zoom)/2.0f;
    ShiftX = (Posx-width/2.0f)/main.Zoom;
    ShiftY = (Posy-height/2.0f)/main.Zoom;
    main.display();
  }
  
  // starts building the object
  public void build(){
    build.hide();
    window = Window.Building;  
    ShiftX = (Posx-width/2.0f)/main.Zoom;
    ShiftY = (Posy-height/2.0f)/main.Zoom;    
    main.display();
  }
  
  //places the object at the nearest position
  public void place(){
    boolean yCoord = false;
    for(int i = main.XCoord.size()-1; i >= 0; i--){
      if((main.XCoord.get(i) >= Posx-main.x*main.Zoom/2.0f) && (main.XCoord.get(i) < Posx+main.x*main.Zoom/2.0f)){
        Posx = main.XCoord.get(i)-main.Zoom*MoveX;
        if(i%2 == 0){
          yCoord = false;
        }else{
          yCoord = true;
        }
        break;
      }
    }
    if (yCoord){
      for(int i = main.YCoord1.size()-1; i >= 0; i--){
      if((main.YCoord1.get(i) > Posy-main.y*main.Zoom) && (main.YCoord1.get(i) <= Posy+main.y*main.Zoom)){
        Posy = main.YCoord1.get(i)-main.Zoom*MoveY;
        break;
      }
    }
    }else{
      for(int i = main.YCoord2.size()-1; i >= 0; i--){
        if((main.YCoord2.get(i) > Posy-main.y*main.Zoom) && (main.YCoord2.get(i) <= Posy+main.y*main.Zoom)){
          Posy = main.YCoord2.get(i)-main.Zoom*MoveY;
          break;
        }
      }
    }
    ShiftX = (Posx-width/2.0f)/main.Zoom;
    ShiftY = (Posy-height/2.0f)/main.Zoom;
    
    //sorts the ArrayList depending on the objects positions
    for(int i = 0; i < Object.size(); i++){
      ACEnergyObject object = Object.get(0);
      int k = 0;
      for (int j = 0; j < Object.size()-i;j++){
        ACEnergyObject objects = Object.get(j);
        if(objects.Posx+objects.MiddleX*main.Zoom>object.Posx+object.MiddleX*main.Zoom){
          if(objects.MiddleYLeft*main.Zoom+objects.Posy<object.MiddleYRight*main.Zoom+object.Posy){
            object = objects;
            k = j;
          }
        } else {
          if(objects.MiddleYRight*main.Zoom+objects.Posy<object.MiddleYLeft*main.Zoom+object.Posy){
            object = objects;
            k = j;
          }
        }
      }
      Object.add(object);
      Object.remove(k);
    }
    
    Money = Money-BuildingObject.InvestmentCost;
    main.display();
  }
  
  //checks if the object can be placed at the nearest position
  public boolean ground(){
    float posx = Posx;
    float posy = Posy; 
    boolean yCoord = false;
    for(int i = main.XCoord.size()-1; i >= 0; i--){
      if((main.XCoord.get(i) >= posx-main.x*main.Zoom/2.0f) && (main.XCoord.get(i) < posx+main.x*main.Zoom/2.0f)){
        posx = main.XCoord.get(i)-main.Zoom*MoveX;
        if(i%2 == 0){
          yCoord = false;
        }else{
          yCoord = true;
        }
        break;
      }
    }
    if (yCoord){
      for(int i = main.YCoord1.size()-1; i >= 0; i--){
      if((main.YCoord1.get(i) > posy-main.y*main.Zoom) && (main.YCoord1.get(i) <= posy+main.y*main.Zoom)){
        posy = main.YCoord1.get(i)-main.Zoom*MoveY;
        break;
      }
    }
    }else{
      for(int i = main.YCoord2.size()-1; i >= 0; i--){
        if((main.YCoord2.get(i) > posy-main.y*main.Zoom) && (main.YCoord2.get(i) <= posy+main.y*main.Zoom)){
          posy = main.YCoord2.get(i)-main.Zoom*MoveY;
          break;
        }
      }
    }
    
    int counter = 0;
    for(int i = 0; i < Object.size()-1; i++){
      ACEnergyObject checkObject = Object.get(i);
      int[] x = new int[0];
      int[] y = new int[0];
      for(int j = 0; j < width; j+=5){
        for(int k = 0; k < height; k+=5){
          

          if((k-(checkObject.Posy+checkObject.MiddleYRight*main.Zoom)<-3.0f/4.0f*(j-(checkObject.Posx+(checkObject.MiddleX+checkObject.Width)*main.Zoom)))&&
            (k-(checkObject.Posy+checkObject.MiddleYLeft*main.Zoom)<3.0f/4.0f*(j-(checkObject.Posx+(checkObject.MiddleX-checkObject.Width)*main.Zoom)))&&
            (k-(checkObject.Posy+checkObject.MiddleYRight*main.Zoom)>3.0f/4.0f*(j-(checkObject.Posx+(checkObject.MiddleX+checkObject.Width)*main.Zoom)))&&
            (k-(checkObject.Posy+checkObject.MiddleYLeft*main.Zoom)>-3.0f/4.0f*(j-(checkObject.Posx+(checkObject.MiddleX-checkObject.Width)*main.Zoom)))
            ){

              x = expand(x, x.length+1);
              y = expand(y, y.length+1);
              x[(x.length-1)]=j;
              y[(y.length-1)]=k;
            }
        }
      }
      for(int j = 0; j < width; j+=5){
        for(int k = 0; k < height; k+=5){
          if((k-(Posy+MiddleYRight*main.Zoom)<-3.0f/4.0f*(j-Posx-(MiddleX+Width)*main.Zoom))&&
            (k-(Posy+MiddleYLeft*main.Zoom)<3.0f/4.0f*(j-Posx-(MiddleX-Width)*main.Zoom))&&
            (k-(Posy+MiddleYRight*main.Zoom)>3.0f/4.0f*(j-Posx-(MiddleX+Width)*main.Zoom))&&
            (k-(Posy+MiddleYLeft*main.Zoom)>-3.0f/4.0f*(j-Posx-(MiddleX-Width)*main.Zoom))
            ){
              for(int l = 0; l < x.length; l++){
                if((j == x[l]) && (k == y[l])){
                  return false;
                }   
              }
            }
        }
      }
      counter++;
    }
    if(counter == Object.size()-1){
      return true;
    }
    else{
      return false;
    }
  }
}
/*----------------------------------------------------------------------
ElectriCity

This class contains all the information about nuclear powerplants.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 16.10.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CAKW extends ACEnergyObject{

    CAKW(){
      Image = ImgAKW;
      //size of a nuclear powerplant
      float Size = 3.8f*4;
      SizeX = SizeXMultiplier*Size; 
      SizeY = SizeYMultiplier*Size;
      MiddleX=27.8f*2; MiddleYRight=28.2f*2; MiddleYLeft=34.2f*2;
      Width = 17*2;
      MoveX = -0.003f*SizeX;
      MoveY = 0.005f*SizeY-main.y;
      Happyness = -5000;
      Production = 487000000;
      AverageProduction = 487000000;
      PermanentCost = 19480000;
      InvestmentCost = 3260000000l;
      Emissions = 7305;
      Kind = "AKW";
    }
}
class CAKWsmall extends CAKW{
  CAKWsmall(){
    //size of a small nuclear powerplant
    float Size = 3.8f*2;
    SizeX = SizeXMultiplier*Size; 
    SizeY = SizeYMultiplier*Size;
    MiddleX=27.8f; MiddleYRight=28.2f; MiddleYLeft=34.2f;
    Width = 17;
    MoveX = -0.003f*SizeX;
    MoveY = 0.005f*SizeY-main.y;
    Happyness = -50;
    Production = 4870000;
    AverageProduction = 4870000;
    PermanentCost = 194800;
    InvestmentCost = 32600000;
    Emissions = 7;
    Kind = "AKWs";
  }
}
/*----------------------------------------------------------------------
ElectriCity

This class opens the window, where you can choose which object you want to build.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CBuild{
  //space between two buttons (production)
  int SpaceXP;
  
  //space between two buttons (consumers)
  int SpaceXC;
  
  //space between two buttons in y-direction
  int SpaceY;
  
  //builds the window
  public void setup(){
       PFont build = Calibri; 
       ControlFont font = new ControlFont(build, 20);
       PFont exit = Calibri; 
       ControlFont exitFont = new ControlFont(exit);
       cp5Build.setFont(font);

       SpaceXP = (width-1200)/5;
       SpaceXC = (width-900)/4;
       SpaceY = (height-600)/4-30;
       
       PImage imgAKW = ImgAKW;
       imgAKW.resize(300, 300);
       PImage imgCoal = ImgCoal;
       imgCoal.resize(300, 300);
       PImage imgSolar = ImgSolar;
       imgSolar.resize(300, 300);
       PImage imgWind = ImgWind;
       imgWind.resize(300, 300);
       PImage imgHH = ImgHH;
       imgHH.resize(300, 300);
       PImage imgIB = ImgIB;
       imgIB.resize(300, 300);
       PImage imgPSW = ImgPSW;
       imgPSW.resize(300,300);
    
    //all buttons
    //build buttons
     BBuildExit = cp5Build.addButton("BBuildExit")
     .setLabel("<-")
     .setPosition(20, 20)
     .setSize(70,70)
     .setFont(exitFont)
     ;
     BBuildExit.hide();
     
    BBuildAKW = cp5Build.addButton("BBuildAKW")
     .setImage(imgAKW)
     .setPosition(SpaceXP, SpaceY)
     .setSize(300,300)
     ;
     BBuildAKW.hide();
     
     BBuildCoal = cp5Build.addButton("BBuildCoal")
     .setImage(imgCoal)
     .setPosition(2*SpaceXP + 300, SpaceY)
     .setSize(300,300)
     ;
     BBuildCoal.hide();
     
     BBuildWind = cp5Build.addButton("BBuildWind")
     .setImage(imgWind)
     .setPosition(3*SpaceXP+600, SpaceY)
     .setSize(300,300)
     ;
     BBuildWind.hide();
     
     BBuildPV = cp5Build.addButton("BBuildPV")
     .setImage(imgSolar)
     .setPosition(4*SpaceXP+900, SpaceY)
     .setSize(300,300)
     ;
     BBuildPV.hide();
     
     BBuildHH = cp5Build.addButton("BBuildHH")
     .setImage(imgHH)
     .setPosition(SpaceXC, 3*SpaceY+300)
     .setSize(300,300)
     ;
     BBuildHH.hide();
     
     BBuildIB = cp5Build.addButton("BBuildIB")
     .setImage(imgIB)
     .setPosition(2*SpaceXC + 300, 3*SpaceY+300)
     .setSize(300,300)
     ;
     BBuildIB.hide();
     
     BBuildPSW = cp5Build.addButton("BBuildPSW")
     .setImage(imgPSW)
     .setPosition(3*SpaceXC+600,3*SpaceY+300)
     .setSize(300,300)
     ;
     BBuildPSW.hide();
    
  
    //detailsButtons  
    BDetailsAKW = cp5Build.addButton("BDetailsAKW")
     .setLabel("nuclear power plant")
     .setPosition(SpaceXP, SpaceY+310)
     .setSize(300,80)
     ;
     BDetailsAKW.hide();
     
     BDetailsCoal = cp5Build.addButton("BDetailsCoal")
     .setLabel("coal-fired power station")
     .setPosition(2*SpaceXP + 300, SpaceY+310)
     .setSize(300,80)
     ;
     BDetailsCoal.hide();
     
     BDetailsWind = cp5Build.addButton("BDetailsWind")
     .setLabel("wind turbine")
     .setPosition(3*SpaceXP+600, SpaceY+310)
     .setSize(300,80)
     ;
     BDetailsWind.hide();
     
     BDetailsPV = cp5Build.addButton("BDetailsPV")
     .setLabel("photovoltaic")
     .setPosition(4*SpaceXP+900, SpaceY+310)
     .setSize(300,80)
     ;
     BDetailsPV.hide();
     
     BDetailsHH = cp5Build.addButton("BDetailsHH")
     .setLabel("household")
     .setPosition(SpaceXC, 3*SpaceY+610)
     .setSize(300,80)
     ;
     BDetailsHH.hide();
     
     BDetailsIB = cp5Build.addButton("BDetailsIB")
     .setLabel("industrial building")
     .setPosition(2*SpaceXC + 300, 3*SpaceY+610)
     .setSize(300,80)
     ;
     BDetailsIB.hide();
     
     BDetailsPSW = cp5Build.addButton("BDetailsPSW")
     .setLabel("storage plant")
     .setPosition(3*SpaceXC+600,3*SpaceY+610)
     .setSize(300,80)
     ;
     BDetailsPSW.hide();

    
  }
  //draws the background and shows every button
  public void display(){
    background(255,255,255);
    BBuildExit.show();
    BBuildAKW.show();
    BBuildCoal.show();
    BBuildPSW.show();
    BBuildWind.show();
    BBuildPV.show();
    BBuildHH.show();
    BBuildIB.show();
    BDetailsAKW.show();
    BDetailsCoal.show();
    BDetailsPSW.show();
    BDetailsWind.show();
    BDetailsPV.show();
    BDetailsHH.show();
    BDetailsIB.show();
  }
  
  //hides every button
  public void hide(){
    BBuildExit.hide();
    BBuildAKW.hide();
    BBuildCoal.hide();
    BBuildPSW.hide();
    BBuildWind.hide();
    BBuildPV.hide();
    BBuildHH.hide();
    BBuildIB.hide();
    BDetailsAKW.hide();
    BDetailsCoal.hide();
    BDetailsPSW.hide();
    BDetailsWind.hide();
    BDetailsPV.hide();
    BDetailsHH.hide();
    BDetailsIB.hide();
  }
}
/*----------------------------------------------------------------------
ElectriCity

This class opens a window, with two buttons, where you can choose the 
size of the object you are about to build.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CChoose{
  
  //checks what type of object is being built
  int type = 0; 
  
  //builds the window
  public void setup(){
    PFont exit = Calibri; 
    ControlFont exitFont = new ControlFont(exit);
    
    //all buttons
    BChooseExit = cp5Build.addButton("BChooseExit")
     .setLabel("<-")
     .setPosition(20, 20)
     .setSize(70,70)
     .setFont(exitFont)
     ;
     BChooseExit.hide();
     
    BLarge = cp5Start.addButton("BLarge")
     .setLabel("large")
     .setPosition(width/2+10, height/2-200)
     .setSize(450,450)
     ;
     BLarge.hide();
     
    BSmall = cp5Start.addButton("BSmall")
     .setLabel("small")
     .setPosition(width/2-460, height/2-200)
     .setSize(450,450)
     ;
     BSmall.hide();
  }
  
  //shows every button
  public void show(){
    BChooseExit.show();
    BLarge.show();
    BSmall.show();
  }
  
  //hides every button
  public void hide(){
    BChooseExit.hide();
   BLarge.hide();
   BSmall.hide();
  }
}
/*----------------------------------------------------------------------
ElectriCity

This class contains all the information about coal-fired powerplants.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CCoal extends ACEnergyObject{
  CCoal(){
      Image = ImgCoal; 
      //size of a coal-fired powerplant
      float Size = 1.7f*8;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      Width = 7.1f*2;
      MoveX = 0.4f/10*SizeX-8.0f/3.0f;
      MoveY = 0.88f/10*SizeY-2;
      MiddleX = 25.3f*2; MiddleYRight = 34.3f*2; MiddleYLeft = 37.4f*2;
      Happyness = -1380;
      Production = 302000000;
      AverageProduction = 302000000;
      PermanentCost = 2250000;
      InvestmentCost = 759000000;
      Emissions = 381915000;
      Kind = "Coal";
    }
}
class CCoalsmall extends CCoal{
  CCoalsmall(){
      Image = ImgCoal; 
      //size of a coal-fired powerplant
      float Size = 1.7f*4;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      Width = 7.1f;
      MoveX = 0.4f/10*SizeX-8.0f/3.0f;
      MoveY = 0.88f/10*SizeY-2;
      MiddleX = 25.3f; MiddleYRight = 34.3f; MiddleYLeft = 37.4f;
      Happyness = -14;
      Production = 3020000;
      AverageProduction = 3020000;
      PermanentCost = 22500;
      InvestmentCost = 7590000;
      Emissions = 3819150;
      Kind = "Coals";
    }
}
/*----------------------------------------------------------------------
ElectriCity

This opens a window, which appears when you lose.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 16.10.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CDead{
  //the reason why you lost the game
  String Reason = "";
  
  //opens the window
  public void open(){
    background(0);
    report.hide();
    window = Window.Dead;
    textFont(Calibri);
    fill(255, 0, 0);
    text("You lost,"+Reason, width/2-textWidth("You lost,"+Reason)/2, height/2-10);
    report.Die = false;
  }
  
  
}
/*----------------------------------------------------------------------
ElectriCity

This opens a window which shows the detailed information about an object.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CDetails{
  //titles of the window
  String prod = "energy production";
  String invest = "investment cost";
  String monthly = "mothly profit";
  String emissions = "emissions";
  String happyness = "workers";
  
  //name of the objects image
  String ImageName;
  
  //name of the creator of the objects image
  String ImageCreator;
  
  //other text needed for the license
  String Attribution = "Creators Common Attribution";
  String By = "by ";
  String Licensed = "is licensed under "; 
  
  //link to find the image
  String LinkImage;
  
  //link to find the creator
  String LinkCreator;
  
  //builds the window
  public void setup(){
    PFont details = Calibri; 
     ControlFont exit = new ControlFont(details);
     cp5Details.setFont(exit);
     
    BDetailsExit = cp5Details.addButton("BDetailsExit")
     .setLabel("<-")
     .setPosition(20, 20)
     .setSize(70,70)
     ;
     BDetailsExit.hide();
  }
  
  //shows the window
  public void display(){
    BDetailsExit.show();
    background(255,255,255);
    stroke(0,0,0);
    noFill();
    
    //structure
    strokeWeight(2);
    line(20, 100, width-20, 100);
    for(int i = 1; i < 6; i++){ 
      line((width-40)/6*i, 30, (width-40)/6*i, 240);
    }
    
    fill(main.Dark);
    textFont(Calibri, 30);
    
    //titles
    text(prod, (width-40)/6+((width-40)/6-textWidth(prod))/2, 70);
    text(invest, (width-40)/6*2+((width-40)/6-textWidth(invest))/2, 70);
    text(monthly, (width-40)/6*3+((width-40)/6-textWidth(monthly))/2, 70);
    text(emissions, (width-40)/6*4+((width-40)/6-textWidth(emissions))/2, 70);
    text(happyness, (width-40)/6*5+((width-40)/6-textWidth(happyness))/2, 70);
    
    text(DetailsTitle, ((width-40)/6-textWidth(DetailsTitle))/2, 140);
    text(DetailsTitle2, ((width-40)/6-textWidth(DetailsTitle2))/2, 190);
    
    //values
    text(str(Objects.AverageProduction), (width-40)/6+((width-40)/6-textWidth(str(Objects.AverageProduction)))/2, 140);
    text(str(Objects2.AverageProduction), (width-40)/6+((width-40)/6-textWidth(str(Objects2.AverageProduction)))/2, 190);
    text("\nkWh/month", (width-40)/6+((width-40)/6-textWidth("\nkWh/month"))/2, 190);
    
    text(Objects.InvestmentCost+"", (width-40)/6*2+((width-40)/6-textWidth(Objects.InvestmentCost+""))/2, 140);
    text(Objects2.InvestmentCost+"", (width-40)/6*2+((width-40)/6-textWidth(Objects2.InvestmentCost+""))/2, 190);
    text("\n$", (width-40)/6*2+((width-40)/6-textWidth("\n$"))/2, 190);
    
    text(str(-Objects.PermanentCost), (width-40)/6*3+((width-40)/6-textWidth(str(-Objects.PermanentCost)))/2, 140);
    text(str(-Objects2.PermanentCost), (width-40)/6*3+((width-40)/6-textWidth(str(-Objects2.PermanentCost)))/2, 190);
    text("\n$/month", (width-40)/6*3+((width-40)/6-textWidth("\n$/month"))/2, 190);
    
    text(str(Objects.Emissions), (width-40)/6*4+((width-40)/6-textWidth(str(Objects.Emissions)))/2, 140);
    text(str(Objects2.Emissions), (width-40)/6*4+((width-40)/6-textWidth(str(Objects2.Emissions)))/2, 190);
    text("\nkg(CO2)/month", (width-40)/6*4+((width-40)/6-textWidth("\nkg(CO2)/month"))/2, 190);
    
    text(str(Objects.Happyness), (width-40)/6*5+((width-40)/6-textWidth(str(Objects.Happyness)))/2, 140);
    text(str(Objects2.Happyness), (width-40)/6*5+((width-40)/6-textWidth(str(Objects2.Happyness)))/2, 190);
    
    //image
    image(DetailsImage, 40, 400, width/2+200, height-500);
    
    
    //license
    textFont(Calibri, 20);
    fill(70,186,224);
    text(ImageName, width-30-textWidth(ImageName)-textWidth(By)-textWidth(ImageCreator)-textWidth(Licensed)-textWidth(Attribution) ,height-30);
    text(ImageCreator, width-30-textWidth(ImageCreator)-textWidth(Licensed)-textWidth(Attribution) , height-30);
    text(Attribution, width-30-textWidth(Attribution) , height-30);
    fill(0);
    text(By, width-30-textWidth(By)-textWidth(ImageCreator)-textWidth(Licensed)-textWidth(Attribution) , height-30);
    text(Licensed, width-30-textWidth(Licensed)-textWidth(Attribution) , height-30);
  }

  //hides the button
  public void hide(){
   BDetailsExit.hide(); 
  }
}
/*----------------------------------------------------------------------
ElectriCity

This opens the window, where you can pay your emission taxes.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CEmissionTaxes extends PApplet {
  //the windows size
  public void settings() {
    size(400, 250);
  }
  
  //sets the window invisible
  public void setup(){
    surface.setVisible(false); 
  }
  
  //opens the window
  public void open(){
    surface.setVisible(true);
    Taxe = true;
  }
  
  //closes the window
  public void hide(){
    surface.setVisible(false); 
    Taxe = false;
  }
  
  //draws texts, lines and buttons
  public void draw() {
    background(0);
    textFont(Calibri);
    fill(255, 0, 0);
    String text = "Attention!";
    text(text, width/2-textWidth(text)/2, 50);
    stroke(255,0,0);
    line(0,70,width,70);
    text = "Your emission taxes are due!";
    textFont(Calibri, 30);
    text(text, width/2-textWidth(text)/2, 100);
    text = "You have to pay:";
    text(text, width/2-textWidth(text)/2, 150);
    
    String emissions = Long.toString(CO2/1000*Tax) + " $";
    if(CO2/100000000 > 1000000000){
      emissions = str(round(CO2/10000000/100000000))+" P";
    }
    else if(CO2/100000 > 1000000000){
      emissions = str(round(CO2/100000/10000000))+" G";
    }
    else if(CO2/100 > 1000000000){
      emissions = str(round(CO2/1000000000))+" M";
    }else if(CO2 > 100000000){
      emissions = str(round(CO2/1000000))+" k";
    }
    text(emissions, (width-100)/2-textWidth(emissions)/2, 200);
    noStroke();
    if(mouseX > 240 && mouseX < 370 && mouseY > 170 && mouseY < 210){
      fill(0,116,217);
    } else {
      fill(0,45,90);
    }
    rect(240,170,130,40);
    fill(255);
    textFont(Calibri, 30);
    text("Pay now", 250, 200);
  }
  
  //checks if the button has been pressed when the mouse is released and if so, pays the emission taxes
  public void mouseReleased(){
    if(mouseX > 240 && mouseX < 370 && mouseY > 170 && mouseY < 210){
      Money-=CO2/1000*Tax;
      CO2 = 0;
      hide();
      report.hide();
      main.display();
      window = Window.Main;
    }
  }
  
  //makes sure you can't close the window
  @Override
    public void exit() {
  }
}
/*----------------------------------------------------------------------
ElectriCity

This classes contain all the information about households.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 16.10.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CHousehold extends ACEnergyObject{
      
    CHousehold(){
      Image = ImgHH; 
      float Size = 2;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      Width = 3.8f;
      MoveX = -0.65f;
      MoveY = -0.87f;
      MiddleX = 7.3f; MiddleYRight = 11.1f; MiddleYLeft = 9.2f;
      Happyness = 130/2;
      Production = -39990/2;
      AverageProduction = -39990/2;
      PermanentCost = -13730/2;
      InvestmentCost = 5380000/2;
      Emissions = 22460/2;
      Kind = "HouseHold";
    }
}

class CHouseholdbig extends CHousehold{
      
    CHouseholdbig(){
      Image = ImgHH; 
      float Size = 4;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      Width = 3.8f*2;
      MoveX = -0.65f*2;
      MoveY = -0.87f*2;
      MiddleX = 7.3f*2; MiddleYRight = 11.1f*2; MiddleYLeft = 9.2f*2;
      Happyness = 1300/2;
      Production = -399900/2;
      AverageProduction = -399900/2;
      PermanentCost = -137300/2;
      InvestmentCost = 53800000/2;
      Emissions = 224600/2;
      Kind = "HouseHoldl";
    }
}
/*----------------------------------------------------------------------
ElectriCity

This class contains all the information about factories.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CIndustrialBuilding extends ACEnergyObject{
  
  CIndustrialBuilding(){
      Image = ImgIB; 
      float Size = 4.2f;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      Width = 8;
      MoveX = 0.05f;
      MoveY = -0.4f;
      MiddleX = 15.3f; MiddleYRight = 24.6f; MiddleYLeft = 21.5f;
      Happyness = -100;
      Production = -27351;
      AverageProduction = -27351;
      PermanentCost = -57391;
      InvestmentCost = 2010000;
      Emissions = 3392;
      Kind = "IndustrialBuilding";
    }
}

class CIndustrialBuildingbig extends CIndustrialBuilding{
  CIndustrialBuildingbig(){
      Image = ImgIB; 
      float Size = 4.2f*2;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      Width = 8*2;
      MoveX = 0.05f*2;
      MoveY = -0.4f*2;
      MiddleX = 15.3f*2; MiddleYRight = 24.6f*2; MiddleYLeft = 21.5f*2;
      Happyness = -1000;
      Production = -27351*10;
      AverageProduction = -27351*10;
      PermanentCost = -57391*10;
      InvestmentCost = 2010000*10;
      Emissions = 3392*10;
      Kind = "IndustrialBuildingl";
    }
}
/*----------------------------------------------------------------------
ElectriCity

This class draws the main window including the background and every 
object you built.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 05.10.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CMain{
      
  // creates the window with all components (except from the background)
  public void setup(){ 
     PFont mainLabels = Calibri; 
     ControlFont labels = new ControlFont(mainLabels, 20);
  
     PFont main = Calibri; 
     ControlFont font = new ControlFont(main, 30);
     cp5Main.setFont(font);
     
     PFont mainExit = Calibri; 
     ControlFont exit = new ControlFont(mainExit);
    
     BBuild = cp5Main.addButton("BBuild")
     .setLabel("Build")
     .setPosition(width-440,height-120)
     .setSize(200,100)
     ;
     BBuild.hide();
     
     BSimulate = cp5Main.addButton("BSimulate")
     .setLabel("Simulate")
     .setPosition(width-220,height-120)
     .setSize(200,100)
     ;
     BSimulate.hide();
     
     BExpectation = cp5Main.addButton("BExpectation")
     .setLabel("Expectation")
     .setPosition(width-660,height-120)
     .setSize(200,100)
     ;
     BExpectation.hide();
     
     BExit = cp5Main.addButton("BExit")
     .setLabel("<-")
     .setFont(exit)
     .setPosition(20,20)
     .setSize(70,70)
     ;
     BExit.hide();
     
     SZoom = cp5Main.addSlider("SZoom")
     .setPosition(width-100,height/2-250)
     .setSize(50,500)
     .setRange(3,90)
     .setValue(15)
     .setSliderMode(Slider.FLEXIBLE)
     .setHandleSize(70)
     ;
     SZoom.getValueLabel().hide();
     SZoom.getCaptionLabel().hide();
     SZoom.hide();
     
     LMonth = cp5Main.addButton("LMonth")
                  .setLabel("Month: "+str(Month))
                  .setPosition(width-500,20)
                  .setSize(200,40)
                  .setFont(labels)
                  .hide()
                  ;
                  
    LYear = cp5Main.addButton("LYear")
                  .setLabel("Year: "+str(Year))
                  .setPosition(width-750,20)
                  .setSize(200,40)
                  .setFont(labels)
                  .hide()
                  ;
                  
    LWorkers = cp5Main.addButton("LWorkers")
                  .setLabel("Workers: "+str(Workers))
                  .setPosition(width-250,20)
                  .setSize(200,40)
                  .setFont(labels)
                  .hide()
                  ;
                  
    LMoney = cp5Main.addButton("LMoney")
                  .setLabel("Money: "+str(Money))
                  .setPosition(width-250,70)                  
                  .setSize(200,40)
                  .setFont(labels)
                  .hide()
                  ;
                  
    LEnergy = cp5Main.addButton("LEnergy")
                  .setLabel("Energy: "+str(Energy))
                  .setPosition(width-250,120)                  
                  .setSize(200,40)
                  .setFont(labels)
                  .hide()
                  ;
                  
   LCO2 = cp5Main.addButton("LCO2")
                  .setLabel("Emissions: "+ str(CO2))
                  .setPosition(width-250,170)                  
                  .setSize(200,40)
                  .setFont(labels)
                  .hide()
                  ;
  }

  // shows everything in main (called when the window is opened)
  public void display(){
    bg();
    BBuild.show();
    BSimulate.show();
    BExpectation.show();
    BExit.show();
    SZoom.show();
    String money = str(round(Money))+" $";
    String energy = str(round(Energy))+" k";
    String emissions = str(round(CO2))+" kg";
    
    if(Money/100000000 > 1000000000){
      money = str(round(Money/10000000/100000000))+" P";
    }
    else if(Money/100000 > 1000000000){
      money = str(round(Money/100000/10000000))+" T";
    }
    else if(Money/100 > 1000000000){
      money = str(round(Money/1000000000))+" G";
    }else if(Money > 100000000){
      money = str(round(Money/1000000))+" M";
    }else if(Money > 100000){
      money = str(round(Money/1000))+" k";
    }
    
    if(Energy/100000000 > 1000000000){
      energy = str(round(Energy/10000000/100000000))+" E";
    }
    else if(Energy/100000 > 1000000000){
      energy = str(round(Energy/100000/10000000))+" P";
    }
    else if(Energy/100 > 1000000000){
      energy = str(round(Energy/1000000000))+" T";
    }else if(Energy > 100000000){
      energy = str(round(Energy/1000000))+" G";
    }else if(Energy > 100000){
      energy = str(round(Energy/1000))+" M";
    }
    
    
    if(CO2/100000000 > 1000000000){
      emissions = str(round(CO2/10000000/100000000))+" Pt";
    }
    else if(CO2/100000 > 1000000000){
      emissions = str(round(CO2/100000/10000000))+" Gt";
    }
    else if(CO2/100 > 1000000000){
      emissions = str(round(CO2/1000000000))+" Mt";
    }else if(CO2 > 100000000){
      emissions = str(round(CO2/1000000))+" kt";
    }else if(CO2 > 100000){
      emissions = str(round(CO2/1000))+" t";
    }
    
    String month = "January";
    switch(Month){
      case 2: month = "february"; break;
      case 3: month = "march"; break;
      case 4: month = "april"; break;
      case 5: month = "may"; break;
      case 6: month = "june"; break;
      case 7: month = "july"; break;
      case 8: month = "august"; break;
      case 9: month = "september"; break;
      case 10: month = "october"; break;
      case 11: month = "november"; break;
      case 12: month = "december"; break;
      default: break;
    }
    
    LMonth.setLabel("Month: "+month);
    LWorkers.setLabel("Workers: "+str(Workers));
    LMoney.setLabel("Money: "+money);
    LEnergy.setLabel("Energy: "+energy+"Wh");
    LCO2.setLabel("Emissions: "+ emissions);
    LYear.setLabel("Year: "+ str(Year));
    LMonth.show();
    LWorkers.show();
    LMoney.show();
    LEnergy.show();
    LCO2.show();
    LYear.show();
    
    //for (int i = Object.size()-1; i >= 0; i--){
      for (int i = 0; i<Object.size(); i++){
      ACEnergyObject object = Object.get(i);
      object.display();
    }
  }
  
  // hides everything in main (called when the window is closed)
  public void hide(){
    BBuild.hide();
    BSimulate.hide();
    BExpectation.hide();
    BExit.hide();
    SZoom.hide();
    LMonth.hide();
    LWorkers.hide();
    LMoney.hide();
    LEnergy.hide();
    LCO2.hide();
    LYear.hide();
    Grabbed = false;
  }
  
  //here is everything for the background
  //x-coordinate
  float PosX = 0;
  
  //y-coordinate
  float PosY = 0;
  
  //number to remember how big everything has to be
  float Zoom = 15;
  
  //checks if the background has been grabbed (= has to follow the mouse)
  boolean Grabbed = false;
  
  //dark green
  int Dark = color(1,110,9);
  
  //light green
  int Light = color(91,217,35);
  
  //width of one field
  float x = 4.0f/3.0f;
  
  //height of one field
  float y = 1;
  
  //stores the x-coordinates of every field
  IntList XCoord = new IntList();
  
  //stores the y-coordinates of every field in an odd column
  IntList YCoord1 = new IntList();
  
  //stores the y-coordinates of every field in an even column
  IntList YCoord2 = new IntList();
  
  //checks if the current column is even or odd
  boolean YCoord = false;
  
  //draws and calculates the background
  public void bg(){
    background(Dark);
    float iChange = x*Zoom;
    float jChange = y*Zoom;
    float numberX = (int)((float)(width/2)/((float)(iChange)));
    float numberY = (int)((float)(height/2)/((float)(jChange)));
    
    //prevents the background from flickering when zooming
    if(numberX%2 != 0){
      numberX++;
    }
    if(numberY%2 != 0){
      numberY++;
    }
    
    
    float posX0 = width/2-numberX*iChange-3*x*iChange+PosX;
    float posY0 = height/2-numberY*jChange-y*jChange+PosY;
    float j0 = posY0;
    int counter = 0;
    noStroke();
    
    
    //prevents the background from beginning inside the window
    while(PosX > x*Zoom){
        PosX-=2*x*Zoom;
      }while(PosX < -x*Zoom){
        PosX+=2*x*Zoom;
      }
      while(PosY > y*Zoom){
        PosY-=2*y*Zoom;
      }while(PosY < -y*Zoom){
        PosY+=2*y*Zoom;
      }
      
    // draws the background
    XCoord.clear();
    for(float i = posX0; i < (width+iChange); i+=iChange){
      XCoord.append((int)i);
      if(counter%2 == 0){
          fill(Dark);
          YCoord1.clear();
          YCoord = true;
        }else{
          fill(Light);
          YCoord2.clear();
          YCoord = false;
        }
      for(float j = j0; j < (height+jChange); j+=2*jChange){
        if(YCoord){
          YCoord1.append((int)j); 
        }else{
          YCoord2.append((int)j);
        }
        quad(i, j, i+iChange, j+jChange, i+2*iChange, j, i+iChange, j-jChange);
      }
      if (j0 == posY0){
        j0 = posY0+jChange;
      }else{
        j0 = posY0;
      }
      counter++;
    }
  }
  
  //moves the background and every object
  public void move(){
    // checks if the the mouse hasn't pressed a button or slider and moves the background
    if(!(BBuild.isPressed() || BSimulate.isPressed() || BExpectation.isPressed() || BExit.isPressed() || SZoom.isMouseOver())){
      PosX = PosX + mouseX - pmouseX;
      PosY = PosY + mouseY - pmouseY;
      
      // prevents the background from beginning inside the window
      while(PosX > x*Zoom){
        PosX-=2*x*Zoom;
      }while(PosX < -x*Zoom){
        PosX+=2*x*Zoom;
      }
      while(PosY > y*Zoom){
        PosY-=2*y*Zoom;
      }while(PosY < -y*Zoom){
        PosY+=2*y*Zoom;
      }
      //moves the objects
      for (int i = Object.size()-1; i >= 0; i--){
        ACEnergyObject object = Object.get(i);
        object.Posx = object.Posx + mouseX - pmouseX;
        object.Posy = object.Posy + mouseY - pmouseY;
        object.ShiftX = (object.Posx-width/2.0f)/Zoom;
        object.ShiftY = (object.Posy-height/2.0f)/Zoom;
      }
      // redraws the window
      display();
    }
  }
}
/*----------------------------------------------------------------------
ElectriCity

This class opens a window, where you can save&close the game or delete it.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CMenu extends PApplet{
  
  //defines the windows size
  public void settings() {
    size(400, 200);
  }
  
  //draws the buttons and texts
  public void draw(){
    noStroke();
    if(mouseX > 20 && mouseX < 190 && mouseY > 50 && mouseY < 130){
      fill(0,116,217);
    } else {
      fill(0,45,90);
    }
    rect(20,50,170,80);
    if(mouseX > 210 && mouseX < 380 && mouseY > 50 && mouseY < 130){
      fill(0,116,217);
    } else {
      fill(0,45,90);
    }
    rect(210,50,170,80);
    fill(255);
    textFont(Calibri, 30);
    text("save & close", 30, 100);
    text("delete", 250,100);
  }
  
  //checks if a button has been pressed
  public void mouseReleased(){
    if(mouseX > 20 && mouseX < 190 && mouseY > 50 && mouseY < 130){
      save();
    } else if(mouseX > 210 && mouseX < 380 && mouseY > 50 && mouseY < 130){
      close2();
    }
  }
  
  //saves the data and stops the application 
  public void save(){
    save2();
    close2();
  }
  
  //makes sure the window can be closed without closing the whole application
  @Override
    public void exit() {
  }
}
  
/*----------------------------------------------------------------------
ElectriCity

This class is responsible for the simulation itself. It calculates your
monthly performance and opens a window which contains all this data.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 05.10.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CReport{
  //turns true if you don't produce enough electricity (-> you lose)
  boolean Die = false;
  
    //builds the window
    public void setup(){
    PFont mainExit = Calibri; 
    ControlFont exit = new ControlFont(mainExit);
     
    BReportExit = cp5Report.addButton("BReportExit")
     .setLabel("OK")
     .setFont(exit)
     .setPosition(width-115, height-95)
     .setSize(100,80)
     ;
     BReportExit.hide();
  }
  
  //hides the button
  public void hide(){
    BReportExit.hide();
  }
  
  //starts the simulation
  public void simulate(){
    BReportExit.show();
    main.hide();
    window = Window.Simulate;
    background(255);
    int wind = 0;
    int windone = 0;
    int solar = 0;
    int solarone = 0;
    
    //simulates one month after another to check if you lose
    for(int i = 0; i < Duration; i++){
      windone = Wind.calcProduction();
      solarone = (int)Solar.calcProduction(Month, true);
      wind += windone;
      solar += solarone;
      if(getNr("PSW")*PSW.Production+getNr("PSWs")*PSWs.Production > Energy){
        if(getNr("AKW")*AKW.Production+getNr("AKWs")*AKWs.Production+getNr("Coal")*Coal.Production+getNr("Coals")*Coals.Production+windone*getNr("Wind")+windone*10*getNr("Windl")+solarone*100*getNr("Solarl")+solarone*getNr("Solar")+Energy < -(getNr("HouseHold")*HH.Production+getNr("HouseHoldl")*HHl.Production+getNr("IndustrialBuilding")*IB.Production+getNr("IBl")*IBl.Production)){
           dead.Reason = " because you didn't produce enough energy.";
           report.hide();
           dead.open();
           Die = true;
        }
      } else {
         if(getNr("AKW")*AKW.Production+getNr("AKWs")*AKWs.Production+getNr("Coal")*Coal.Production+getNr("Coals")*Coals.Production+windone*getNr("Wind")+windone*10*getNr("Windl")+solarone*100*getNr("Solarl")+solarone*getNr("Solar")+getNr("PSW")*PSW.Production+getNr("PSWs")*PSWs.Production < -(getNr("HouseHold")*HH.Production+getNr("HouseHoldl")*HHl.Production+getNr("IndustrialBuilding")*IB.Production+getNr("IBl")*IBl.Production)){
           dead.Reason = " because you didn't produce enough energy.";
           report.hide();
           dead.open();
           Die = true;
        }
      }
      if((getNr("AKW")*AKW.Production+getNr("AKWs")*AKWs.Production+getNr("Coal")*Coal.Production+getNr("Coals")*Coals.Production+windone*getNr("Wind")+windone*10*getNr("Windl")+solarone*100*getNr("Solarl")+solarone*getNr("Solar")+getNr("HouseHold")*HH.Production+getNr("HouseHoldl")*HHl.Production+getNr("IndustrialBuilding")*IB.Production+getNr("IBl")*IBl.Production)*0.8f > getNr("PSW")*PSW.Production+getNr("PSWs")*PSWs.Production){
         Energy += getNr("PSW")*PSW.Production+getNr("PSWs")*PSWs.Production;
      } else{
         Energy += (getNr("AKW")*AKW.Production+getNr("AKWs")*AKWs.Production+getNr("Coal")*Coal.Production+getNr("Coals")*Coals.Production+windone*getNr("Wind")+windone*10*getNr("Windl")+solarone*100*getNr("Solarl")+solarone*getNr("Solar")+getNr("HouseHold")*HH.Production+getNr("HouseHoldl")*HHl.Production+getNr("IndustrialBuilding")*IB.Production+getNr("IBl")*IBl.Production)*0.8f;
    }
      Month++;
      if(Month == 13){
        Month = 1;
        Year++;
      }
    }
    
    //draws the window which shows you the results of the simulation
    int WindProd = wind * (int)getNr("Wind");
    int WindlProd = wind * 10 * (int)getNr("Windl");
    int SolarProd = solar * (int)getNr("Solar");
    int SolarlProd = solar * 100 * (int)getNr("Solarl");
    
    float placeY = height/11;
    float placeX = (width - 500)/5;
    StringList StringX = new StringList("nuclear powerplants:", "coal-fired power stations:", "wind turbines:", "photovoltaic:", "households:", "industrial buildings:", "storage plants:", "total:");
    StringList StringY = new StringList("amount:","energy-production:\n         (in kWh)","profit:\n (in $)","CO2-emissions:\n        (in kg)","workers:");
    StringList Data = new StringList((getNr("AKW")+getNr("AKWs"))+"", ((getNr("AKW")*AKW.Production+getNr("AKWs")*AKWs.Production)*Duration)+"",((getNr("AKW")*(-AKW.PermanentCost)+getNr("AKWs")*(-AKWs.PermanentCost))*Duration)+"",((getNr("AKW")*AKW.Emissions+getNr("AKWs")*AKWs.Emissions)*Duration)+"",(getNr("AKW")*AKW.Happyness+getNr("AKWs")*AKWs.Happyness)+"",
                                     (getNr("Coal")+getNr("Coals"))+"", ((getNr("Coal")*Coal.Production+getNr("Coals")*Coals.Production)*Duration)+"",((getNr("Coal")*(-Coal.PermanentCost)+getNr("Coals")*(-Coals.PermanentCost))*Duration)+"",((getNr("Coal")*Coal.Emissions+getNr("Coals")*Coals.Emissions)*Duration)+"",(getNr("Coal")*Coal.Happyness+getNr("Coals")*Coals.Happyness)+"",
                                     (getNr("Wind")+getNr("Windl"))+"", (WindProd+WindlProd)+"",((getNr("Wind")*(-Wind.PermanentCost)+getNr("Windl")*(-Windl.PermanentCost))*Duration)+"",((getNr("Wind")*Wind.Emissions+getNr("Windl")*Windl.Emissions)*Duration)+"",(getNr("Wind")*Wind.Happyness+getNr("Windl")*Windl.Happyness)+"",
                                     (getNr("Solar")+getNr("Solarl"))+"", (SolarProd+SolarlProd)+"",((getNr("Solar")*(-Solar.PermanentCost)+getNr("Solarl")*(-Solarl.PermanentCost))*Duration)+"",((getNr("Solar")*Solar.Emissions+getNr("Solarl")*Solarl.Emissions)*Duration)+"",(getNr("Solar")*Solar.Happyness+getNr("Solarl")*Solarl.Happyness)+"",
                                     (getNr("HouseHold")+getNr("HouseHoldl"))+"", ((getNr("HouseHold")*HH.Production+getNr("HouseHoldl")*HHl.Production)*Duration)+"",((getNr("HouseHold")*(-HH.PermanentCost)+getNr("HouseHoldl")*(-HHl.PermanentCost)*Duration))+"",((getNr("HouseHold")*HH.Emissions+getNr("HouseHoldl")*HHl.Emissions)*Duration)+"",(getNr("HouseHold")*HH.Happyness+getNr("HouseHoldl")*HHl.Happyness)+"",
                                     (getNr("IndustrialBuilding")+getNr("IndustrialBuildingl"))+"", ((getNr("IndustrialBuilding")*IB.Production+getNr("IndustrialBuildingl")*IBl.Production)*Duration)+"",((getNr("IndustrialBuilding")*(-IB.PermanentCost)+getNr("IndustrialBuildingl")*(-IBl.PermanentCost))*Duration)+"",((getNr("IndustrialBuilding")*IB.Emissions+getNr("IndustrialBuildingl")*IBl.Emissions)*Duration)+"",(getNr("IndustrialBuilding")*IB.Happyness+getNr("IndustrialBuildingl")*IBl.Happyness)+"",
                                     (getNr("PSW")+getNr("PSWs"))+"", str(0), ((getNr("PSW")*(-PSW.PermanentCost)+getNr("PSWs")*(-PSWs.PermanentCost))*Duration)+"", ((getNr("PSW")*PSW.Emissions+getNr("PSWs")*PSWs.Emissions)*Duration)+"", (getNr("PSW")*PSW.Happyness+getNr("PSWs")*PSWs.Happyness)+""
                                     );                          
    for (int k = 0; k <= 4; k++){
      long total = 0;      
      for (int i=k; i <= Data.size()-1; i += 5){
        total = total+PApplet.parseInt(Data.get(i));
      }
      switch(k){
       // case 1: Energy += total; break;
        case 2: Money = Money + total; break;
        case 3: CO2 = CO2 +total; break;
        default: break;
      }
      Data.append((total)+"");
    }
      
    
    fill(main.Dark);
    stroke(main.Dark);
    strokeWeight(2);
    line(50, height/11*9.5f, width-50, height/11*9.5f);
    textFont(Calibri, 30);
    for (int i = 0; i < StringX.size(); i++){
      text(StringX.get(i), 400-textWidth(StringX.get(i)), placeY * (i+3));
    }
    for (int i = 0; i < StringY.size(); i++){
      text(StringY.get(i), placeX * (i+1)+300-textWidth(StringY.get(i))/2, 100);
    }
    
    int i = 0;
    for (int j = 0; j < StringX.size(); j++){
      for (int k = 0; k < StringY.size(); k++){
        text(Data.get(i), placeX * (k+1)+300-textWidth(Data.get(i))/2, placeY * (j+3));
        i++;
      }
    }
    if(Die){
      dead.open();
    }
  }
  
  //draws the results window without changing any numbers and by only using the estimated numbers
  public void expectation(){
    BReportExit.show();
    main.hide();
    window = Window.Simulate;
    background(255);
    int WindProd = Wind.AverageProduction * (int)getNr("Wind");
    int WindlProd = Windl.AverageProduction * (int)getNr("Windl");
    int solar = (int)Solar.calcProduction(Month, false);
    int SolarProd = solar * (int)getNr("Solar");
    int SolarlProd = solar * 100 * (int)getNr("Solarl");
    
    float placeY = height/11;
    float placeX = (width - 500)/5;
    StringList StringX = new StringList("nuclear powerplants:", "coal-fired power stations:", "wind turbines:", "photovoltaic:", "households:", "industrial buildings:", "storage plants:", "total:");
    StringList StringY = new StringList("amount:","energy-production:\n         (in kWh)","profit:\n (in $)","CO2-emissions:\n        (in kg)","workers:");
    StringList Data = new StringList(getNr("AKW")+getNr("AKWs")+"", (getNr("AKW")*AKW.Production+getNr("AKWs")*AKWs.Production)+"",(getNr("AKW")*(-AKW.PermanentCost-AKW.Emissions*Tax/1000)+getNr("AKWs")*(-AKWs.PermanentCost-AKWs.Emissions*Tax/1000))+"",(getNr("AKW")*AKW.Emissions+getNr("AKWs")*AKWs.Emissions)+"",(getNr("AKW")*AKW.Happyness+getNr("AKWs")*AKWs.Happyness)+"",
                                     getNr("Coal")+getNr("Coals")+"", (getNr("Coal")*Coal.Production+getNr("Coals")*Coals.Production)+"",(getNr("Coal")*(-Coal.PermanentCost-Coal.Emissions*Tax/1000)+getNr("Coals")*(-Coals.PermanentCost-Coals.Emissions*Tax/1000))+"",(getNr("Coal")*Coal.Emissions+getNr("Coals")*Coals.Emissions)+"",(getNr("Coal")*Coal.Happyness+getNr("Coals")*Coals.Happyness)+"",
                                     getNr("Wind")+getNr("Windl"), (WindProd+WindlProd)+"",(getNr("Wind")*(-Wind.PermanentCost-Wind.Emissions*Tax/1000)+getNr("Windl")*(-Windl.PermanentCost-Windl.Emissions*Tax/1000))+"",(getNr("Wind")*Wind.Emissions+getNr("Windl")*Windl.Emissions)+"",(getNr("Wind")*Wind.Happyness+getNr("Windl")*Windl.Happyness)+"",
                                     getNr("Solar")+getNr("Solarl")+"", (SolarProd+SolarlProd)+"",(getNr("Solar")*(-Solar.PermanentCost-Solar.Emissions*Tax/1000)+getNr("Solarl")*(-Solarl.PermanentCost-Solarl.Emissions*Tax/1000))+"",(getNr("Solar")*Solar.Emissions+getNr("Solarl")*Solarl.Emissions)+"",(getNr("Solar")*Solar.Happyness+getNr("Solarl")*Solarl.Happyness)+"",
                                     getNr("HouseHold")+getNr("HouseHoldl")+"", (getNr("HouseHold")*HH.Production+getNr("HouseHoldl")*HHl.Production)+"",(getNr("HouseHold")*(-HH.PermanentCost-HH.Emissions*Tax/1000)+getNr("HouseHoldl")*(-HHl.PermanentCost-HHl.Emissions*Tax/1000))+"",(getNr("HouseHold")*HH.Emissions+getNr("HouseHoldl")*HHl.Emissions)+"",(getNr("HouseHold")*HH.Happyness+getNr("HouseHoldl")*HHl.Happyness)+"",
                                     getNr("IndustrialBuilding")+getNr("IndustrialBuildingl")+"", (getNr("IndustrialBuilding")*IB.Production+getNr("IndustrialBuildingl")*IBl.Production)+"",(getNr("IndustrialBuilding")*(-IB.PermanentCost-IB.Emissions*Tax/1000)+getNr("IndustrialBuildingl")*(-IBl.PermanentCost-IBl.Emissions*Tax/1000))+"",(getNr("IndustrialBuilding")*IB.Emissions+getNr("IndustrialBuildingl")*IBl.Emissions)+"",(getNr("IndustrialBuilding")*IB.Happyness+getNr("IndustrialBuildingl")*IBl.Happyness)+"",
                                     getNr("PSW")+getNr("PSWs")+"", str(0), (getNr("PSW")*(-PSW.PermanentCost-PSW.Emissions*Tax/1000)+getNr("PSWs")*(-PSWs.PermanentCost-PSWs.Emissions*Tax/1000))+"", (getNr("PSW")*PSW.Emissions+getNr("PSWs")*PSWs.Emissions)+"", (getNr("PSW")*PSW.Happyness+getNr("PSWs")*PSWs.Happyness)+""
                                     );                          
    for (int k = 0; k <= 4; k++){
      int total = 0;      
      for (int i=k; i <= Data.size()-1; i += 5){
        total = total+PApplet.parseInt(Data.get(i));
      }
      Data.append(str(total));
    }
      
    
    fill(main.Dark);
    stroke(main.Dark);
    strokeWeight(2);
    line(50, height/11*9.5f, width-50, height/11*9.5f);
    textFont(Calibri, 30);
    for (int i = 0; i < StringX.size(); i++){
      text(StringX.get(i), 400-textWidth(StringX.get(i)), placeY * (i+3));
    }
    for (int i = 0; i < StringY.size(); i++){
      text(StringY.get(i), placeX * (i+1)+300-textWidth(StringY.get(i))/2, 100);
    }
    
    int i = 0;
    for (int j = 0; j < StringX.size(); j++){
      for (int k = 0; k < StringY.size(); k++){
        //int data = int(Data.get(i));
        //if (data>
        text(Data.get(i), placeX * (k+1)+300-textWidth(Data.get(i))/2, placeY * (j+3));
        i++;
      }
    }
    
  }
  
  //checks how many objects of a specific type you have
  public long getNr(String object){
    long Number = 0;
    for(int i = Object.size()-1; i >= 0; i--){
      if(object.equals(Object.get(i).Kind) == true){
        Number++;
      }
    }
    return Number;
  }
  
  
  
  
}
/*----------------------------------------------------------------------
ElectriCity

This class opens a window, where you can choose how long the simulation
should take.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CSimulation{
  
  //builds the window
  public void setup(){
    ControlFont font = new ControlFont(Calibri, 40);
    TSimulation= cp5Start.addTextfield("TSimulation")
     .setPosition(width/2+30,height/2)
     .setSize(400,60)
     .setLabel("")
     .setText("12")
     .setFont(font)
     .setFocus(true)
     .hide()
     ;
     
     BSimulation= cp5Start.addButton("BSimulation")
     .setPosition(width/2+440,height/2)
     .setSize(90,60)
     .setLabel("OK")
     .setFont(font)
     .hide()
     ;
  }
  
  //shows the buttons and draws the window
  public void open(){
    background(0);
    fill(main.Light);
    textFont(Calibri, 40);
    TSimulation.show();
    BSimulation.show();
    text("how many months do you want to simulate?", width/2-10-textWidth("how many months do you want to simulate?"), height/2+35);
  }
  
  //hides the buttons
  public void hide(){
    BSimulation.hide();
    TSimulation.hide();
  }
}
/*----------------------------------------------------------------------
ElectriCity

This window contains all the information about solar panels.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 05.10.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CSolar extends ACEnergyObject{
  
  //number to store the production of the current month 
  float Prod = 0;
  
    CSolar(){
      Image = ImgSolar;
      float Size = 2;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      MoveX = 0.25f/7.3f*SizeX;
      MoveY = 0.54f/7.1f*SizeY-main.y;
      Width = 3.5f;
      MiddleX = 3.6f*2; MiddleYRight = 3.6f*2; MiddleYLeft = 9;
      Happyness = 0;
      AverageProduction = 2499;
      PermanentCost = 43;
      InvestmentCost = 34708;
      Emissions = 167;
      Kind = "Solar";
    }
    
  //calculates the production of a solar panel in the current month
  public float calcProduction(int month, boolean random){
    switch(month){
      case 1: Prod = 743; break;
      case 2: Prod = 1182; break;
      case 3: Prod = 2336; break;
      case 4: Prod = 3106; break;
      case 5: Prod = 4151; break;
      case 6: Prod = 4454; break;
      case 7: Prod = 4508; break;
      case 8: Prod = 3904; break;
      case 9: Prod = 2722; break;
      case 10: Prod = 1567; break;
      case 11: Prod = 770; break;
      case 12: Prod = 550; break;
      default: break;
    }
    if(random){
      Prod = (Prod+Prod*(random(20)-10)/100.0f);
    }
    return Prod;
  }
}

class CSolarbig extends CSolar{
  //number to store the production of the current month 
  float Prod = 0;
  
    CSolarbig(){
      Image = ImgSolar;
      float Size = 4;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      MoveX = 0.25f/7.3f*SizeX;
      MoveY = 0.54f/7.1f*SizeY-main.y;
      Width = 3.5f*2;
      MiddleX = 3.6f*4; MiddleYRight = 3.6f*4; MiddleYLeft = 9*2;
      Happyness = 0;
      AverageProduction = 2499*100;
      PermanentCost = 43*100;
      InvestmentCost = 34708*100;
      Emissions = 167*100;
      Kind = "Solarl";
    }
}
/*----------------------------------------------------------------------
ElectriCity

This class opens the starting window, where you can choose whether you
want to start a new game or continue the last one you saved.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CStart{
  
  //name of the game and text to be written at the top of the starting window
  String Name = "ElectriCity";
  
  //builds the window
  public void setup(){
    PFont build = Calibri; 
    ControlFont font = new ControlFont(build, 60);
    cp5Start.setFont(font);
    
    BStartEndless = cp5Start.addButton("BStartNew")
     .setLabel("Start\nnew game")
     .setPosition(width/2+10, height/2)
     .setSize(450,450)
     .hide()
     ;

   BContinue = cp5Start.addButton("BContinue")
     .setLabel("Continue\nlast game")
     .setPosition(width/2-460, height/2)
     .setSize(450,450)
     .hide()
     ;
  }
  
  //shows the buttons and draws the rest of the window
  public void open(){
    background(0);
    textFont(Calibri300);
    fill(91,217,35);
    text(Name, width/2-textWidth(Name)/2, 300);
    BStartEndless.show();
    BContinue.show();
  }
  
  //hides the buttons
  public void hide(){
    BStartEndless.hide();
    BContinue.hide();
  }
  
}
/*----------------------------------------------------------------------
ElectriCity

This class opens a window, where you can choose your starting budget
and your emission taxes.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 16.10.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CStartEndless{
  
  //builds the window
  public void setup(){
    SEmissionTaxes = cp5Start.addSlider("SEmissionTaxes")
     .setLabel("")
     .setPosition(width/2,600)
     .setWidth(400)
     .setHeight(30)
     .setRange(0,3) 
     .setValue(3)
     .setNumberOfTickMarks(4)
     .setSliderMode(Slider.FLEXIBLE)
     .hide()
     ;
     SEmissionTaxes.getValueLabel().hide();
    
    SBudget = cp5Start.addSlider("SBudget")
     .setPosition(width/2,470)
     .setSize(400,30)
     .setLabel("")
     .setRange(0,2)
     .setValue(1)
     .setNumberOfTickMarks(3)
     .setSliderMode(Slider.FLEXIBLE)
     .hide()
     ;
     SBudget.getValueLabel().hide();
     
    SEmissionTaxes2 = cp5Start.addSlider("SEmissionTaxes2")
     .setLabel("")
     .setPosition(width/2,600)
     .setWidth(400)
     .setHeight(30)
     .setRange(0,3) 
     .setValue(3)
     .setNumberOfTickMarks(4)
     .setSliderMode(Slider.FLEXIBLE)
     .hide()
     ;
     SEmissionTaxes2.getValueLabel().hide();
    
    BOK = cp5Start.addButton("BOK")
    .setLabel("OK")
    .setPosition(width-200, height-90)
    .setSize(170, 60)
    .hide()
    ;
    
    
  }
  
  //shows the controllers and draws the rest of the window
  public void open(){
    background(0);
    textFont(Calibri300);
    fill(91,217,35);
    text(start.Name, width/2-textWidth(start.Name)/2, 300);
    textFont(Calibri);
    String text = "choose your budget";
    text(text, width/2-textWidth(text)-100, 500);
    text = "choose your emission taxes";
    text(text, width/2-textWidth(text)-100, 630);
    switch((int)SEmissionTaxes.getValue()){
      case 0: text = "25$/ton (Germany in 2021)"; Tax = 25; break;
      case 1: text = "54$/ton (Germany's goal)"; Tax = 54; break;
      case 2: text = "120$/ton (Switzerland in 2021)"; Tax = 120; break;
      case 3: text = "208$/ton (actual value)"; Tax = 208; break;
      default: break;
    }
    text(text, width/2, 680);
    switch((int)SBudget.getValue()){
      case 0: text = "30 Million $"; Money = 30000000;break;
      case 1: text = "40 Million $"; Money = 40000000;break;
      case 2: text = "50 Million $"; Money = 50000000;break;
      default: break;
    }
    text(text, width/2, 550);
    SEmissionTaxes.show();
    BOK.show();
    SBudget.show();     
  }
  
  //hides the controllers
  public void close(){
   SEmissionTaxes.hide(); 
   SEmissionTaxes2.hide();
   BOK.hide();
   SBudget.hide();
  }
  
}
/*----------------------------------------------------------------------
ElectriCity

This class contains all the information about pumped storage plants.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CStoragePlant extends ACEnergyObject{
  
  CStoragePlant(){
    Image = ImgPSW;
    float Size = 3.8f*2;
    SizeX = SizeXMultiplier*Size; //10
    SizeY = SizeYMultiplier*Size;
    MiddleX=14*2; MiddleYRight=20.5f*2; MiddleYLeft=21.5f*2;
    Width = 3.2f*2;
    MoveX = 0*SizeX;
    MoveY = 0.055f*SizeY-main.y;
    Happyness = -8;
    Production = 1300000;
    AverageProduction = 1300000;
    PermanentCost = 152100;
    InvestmentCost = 154000000;
    Emissions = 11100;
    Kind = "PSW"; 
  }
}

class CStoragePlantsmall extends CStoragePlant{
  
  CStoragePlantsmall(){
    Image = ImgPSW;
    //falls Multiplikator bei Size gerade: -main.y an MoveY anhängen
    float Size = 3.8f;
    SizeX = SizeXMultiplier*Size; //10
    SizeY = SizeYMultiplier*Size;
    MiddleX=14; MiddleYRight=20.5f; MiddleYLeft=21.5f;
    Width = 3.2f;
    MoveX = 0*SizeX;
    MoveY = 0.055f*SizeY-main.y;
    Happyness = -1;
    Production = 13000;
    AverageProduction = 13000;
    PermanentCost = 1521;
    InvestmentCost = 1540000;
    Emissions = 110;
    Kind = "PSWs"; 
  }  
}
/*----------------------------------------------------------------------
ElectriCity

This class contains all the information about wind turbines.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 11.09.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

class CWind extends ACEnergyObject{
  
  //stores the production of the current month
  int Prod = 0;
  
  CWind(){
      Image = ImgWind; 
      float Size = 1.7f*3;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      MoveX = -0.43f;
      MoveY = 0.38f;
      MiddleX = 18.2f; MiddleYRight = MiddleYLeft = 28.4f;
      Width = 1;
      Happyness = 0;
      calcProduction();
      Production = calcProduction();
      AverageProduction = 183000;
      PermanentCost = 45458;
      InvestmentCost = 2273000;
      Emissions = 3203;
      Kind = "Wind";
  }
  
  //calculates the production of this month by using a random number and the probaility of each production
  public int calcProduction(){
    float random = random(100);
    if(random <= 5.3f){
      Prod = 0;
    }
    else if(random <= 14.5f){
      Prod = 1000;
    }
    else if(random <= 26.2f){
      Prod = 9000;
    }
    else if(random <= 39){
      Prod = 30000;
    }
    else if(random <= 51.6f){
      Prod = 64000;
    }
    else if(random <= 63.1f){
      Prod = 119000;
    }
    else if(random <= 73){
      Prod = 196000;
    }
    else if(random <= 81){
      Prod = 299000;
    }
    else if(random <= 87.1f){
      Prod = 429000;
    }
    else if(random <= 91.5f){
      Prod = 575000;
    }
    else if(random <= 94.6f){
      Prod = 696000;
    }
    else if(random <= 96.6f){
      Prod = 776000;
    }
    else if(random <= 97.9f){
      Prod = 825000;
    }
    else if(random <= 98.7f){
      Prod = 861000;
    }
    else if(random <= 99.1f){
      Prod = 867000;
    }
    else if(random <= 99.3f){
      Prod = 868000;
    }
    else if(random <= 99.4f){
      Prod = 869000;
    }
    else if(random <= 99.5f){
      Prod = 869000;
    }
    return Prod;
  }
}

class CWindbig extends CWind{
  
  //stores the production of the current month
  int Prod = 0;
  
  CWindbig(){
      Image = ImgWind; 
      float Size = 1.7f*6;
      SizeX = SizeXMultiplier*Size; //10
      SizeY = SizeYMultiplier*Size;
      MoveX = -0.43f*2;
      MoveY = 0.38f*2;
      MiddleX = 18.2f*2; MiddleYRight = MiddleYLeft = 28.4f*2;
      Width = 1*2;
      Happyness = 0;
      calcProduction();
      Production = calcProduction();
      AverageProduction = 183000*10;
      PermanentCost = 45458*10;
      InvestmentCost = 2273000*10;
      Emissions = 3203*10;
      Kind = "Windl";
    }
}
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "ElectriCity3" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
