/*----------------------------------------------------------------------
ElectriCity

This is the main class of the project. 
It controls all the buttons and mousePressed, mouseWheel controls etc.

The whole project simulates the electricity market in switzerland. 
You can build different objects to create a city.

Author: Luc Roth
Date:   24.04.2022

last changed: 16.10.2022

Copyright © 2022 Luc Roth, Herdern, Switzerland. All rights reserved.
----------------------------------------------------------------------*/

//Buttons and Textfields
import controlP5.*;

//to close only one window
import java.awt.*;
import java.awt.event.WindowEvent;
import com.jogamp.newt.opengl.*;

//one object of each class
CMain main = new CMain();
CBuild build = new CBuild();
CDetails details = new CDetails();
CReport report = new CReport();
CAKW AKW = new CAKW();
CAKWsmall AKWs = new CAKWsmall();
CCoal Coal = new CCoal();
CCoalsmall Coals = new CCoalsmall();
CSolar Solar = new CSolar();
CSolarbig Solarl = new CSolarbig();
CWind Wind = new CWind();
CWindbig Windl = new CWindbig();
CHousehold HH = new CHousehold();
CHouseholdbig HHl = new CHouseholdbig();
CIndustrialBuilding IB = new CIndustrialBuilding();
CIndustrialBuildingbig IBl = new CIndustrialBuildingbig();
CStart start = new CStart();
CStartEndless startEndless = new CStartEndless();
CEmissionTaxes Taxes = new CEmissionTaxes();
CMenu Menu = new CMenu();
CDead dead = new CDead();
ACEnergyObject Objects2 = new ACEnergyObject();
CChoose choose = new CChoose();
CStoragePlant PSW = new CStoragePlant();
CStoragePlantsmall PSWs = new CStoragePlantsmall();
CSimulation Simulation = new CSimulation();

//checks if the background is grabbed (and can be moved) or not
boolean Grabbed = false;
//Images of the Objects
PImage ImgAKW;
PImage ImgCoal;
PImage ImgPSW;
PImage ImgSolar;
PImage ImgWind;
PImage ImgHH;
PImage ImgIB;

//groups of buttons
ControlP5 cp5Main;
ControlP5 cp5Build;
ControlP5 cp5Details;
ControlP5 cp5Report;
ControlP5 cp5Start;

//Buttons CBuild
controlP5.Button BBuildAKW;
controlP5.Button BBuildCoal;
controlP5.Button BBuildPSW;
controlP5.Button BBuildWind;
controlP5.Button BBuildPV;
controlP5.Button BBuildHH;
controlP5.Button BBuildIB;
controlP5.Button BDetailsAKW;
controlP5.Button BDetailsCoal;
controlP5.Button BDetailsPSW;
controlP5.Button BDetailsWind;
controlP5.Button BDetailsPV;
controlP5.Button BDetailsHH;
controlP5.Button BDetailsIB;
controlP5.Button BBuildExit;

//Buttons cDetails
controlP5.Button BDetailsExit;

//Buttons CReport
controlP5.Button BReportExit;

//Buttons CStart
controlP5.Button BStartEndless;
controlP5.Button BContinue;

//Buttons CMain
controlP5.Button BBuild;
controlP5.Button BSimulate;
controlP5.Button BExpectation;
controlP5.Button BExit;
controlP5.Slider SZoom;

//Labels CMain
controlP5.Button LMonth;
controlP5.Button LWorkers;
controlP5.Button LMoney;
controlP5.Button LEnergy;
controlP5.Button LCO2;
controlP5.Button LYear;

//Buttons CChoose
controlP5.Button BLarge;
controlP5.Button BSmall;
controlP5.Button BChooseExit;


//Slider CStartEndless
controlP5.Slider SEmissionTaxes;
controlP5.Slider SEmissionTaxes2;
controlP5.Slider SBudget;

//Button CStartEndless
controlP5.Button BOK;

//Textfield/Button CSimulation
controlP5.Textfield TSimulation;
controlP5.Button BSimulation;

//array list to store the objects
ArrayList<ACEnergyObject> Object = new ArrayList<ACEnergyObject>();

//stores the object which is being built
ACEnergyObject BuildingObject;
//stores the Object whose details are being shown
ACEnergyObject Objects;

//Fonts
PFont Calibri;
PFont Calibri300;

//information needed to display CDetails
String DetailsTitle;
String DetailsTitle2;
PImage DetailsImage;

//general data, displayed in window main
int Month = 1;
int Year = 0;
long Money = 0;
long Energy = 0;
long CO2 = 0;
int Workers=0;

//the amount, one ton of CO2 costs
int Tax = 208;
//the duration of the simulation
int Duration = 0;

//checks if expectation or simulation is called
boolean Simulate = false;

//checks if the tutorial needs to be played (only the first time opening the game)
boolean First = false;

//checks if the tutorial is beeing played
boolean Tutorial = false;

//checks if the taxes window needs to be opened again if its closed 
boolean Taxe = false;

//checks which step of the tutorial needs to be shown
int Step = 0;

//checks which window is currently opened
enum Window {
  Start, Main, Build, Building, Simulate, Details, Dead, Taxes, Simulation
}
Window window = Window.Start;

//decides the size
void settings(){
 fullScreen();
}

//loads the images, creates the windows, sets First to true if it,s the first time the game is opened
void setup() {
  cp5Start = new ControlP5(this);
  Calibri = loadFont("Calibri.vlw");
  Calibri300 = loadFont("Calibri-300.vlw");
  start.setup();
  start.open();
  ImgAKW = loadImage("ImgNuclear.png");
  ImgCoal = loadImage("ImgCoal.png");
  ImgPSW =loadImage("ImgPSW.png");
  ImgSolar = loadImage("ImgPV30G.png");
  ImgWind = loadImage("ImgWind.png");
  ImgHH = loadImage("ImgHH.png");
  ImgIB = loadImage("ImgIB.png");
  cp5Main = new ControlP5(this);
  cp5Build = new ControlP5(this);
  cp5Details = new ControlP5(this);
  cp5Report = new ControlP5(this);
  main.setup();
  build.setup();
  details.setup();
  report.setup();
  startEndless.setup();
  choose.setup();
  runSketch(new String[]{"CEmissionTaxes"}, Taxes);
  Taxes.setup();
  Simulation.setup();
  String[] first = loadStrings("data/First.txt");
  if(first[0].equals("0")){
    First = true;
  }
}

// everything that has to be checked each frame and hasn't got it's own method for checking, tutorial
void draw() {
  if(Money < 0){
    dead.Reason = " because you ran out of money.";
    main.hide();
    dead.open();
  }
  switch(window){
    case Main:
      // checks if the background is grabbed and if so calls the method to move it
      if (main.Grabbed == true) {
        main.move();
      }
      break;
    case Building:
      BuildingObject.move();
      break;
    default: break;
  }
  if(First && Tutorial){
        switch(Step){
          case 0:  
            textFont(Calibri);
            arrow(width-600, height-330, width-400,height-130, -1, 1); 
            noStroke();
            fill(255);
            rect(width-910, height-340, textWidth("press build to build objects")+20, -50);
            fill(0);
            text("press build to build objects", width-900, height-350); 
            break;
          
          case 1:
            textFont(Calibri);
            arrow(build.SpaceXC+400, 3*build.SpaceY+400, build.SpaceXC + 250,3*build.SpaceY+600, 1, 1); 
            noStroke();
            fill(255);
            rect(build.SpaceXC+100, 3*build.SpaceY+300, textWidth("see the information about households")+20, -50);
            fill(0);
            text("see the information about households", build.SpaceXC+100, 3*build.SpaceY+300); 
            break;
            
          case 2:
            textFont(Calibri);
            arrow(300, 300, 100, 100, 1, -1); 
            noStroke();
            fill(255);
            rect(250, 380, textWidth("go back")+20, -50);
            fill(0);
            text("go back", 250, 380); 
            break;
            
          case 3:
            textFont(Calibri);
            arrow(build.SpaceXC+300, 3*build.SpaceY+300, build.SpaceXC+200, 3*build.SpaceY+400, 1, 1); 
            noStroke();
            fill(255);
            rect(build.SpaceXC+150, 3*build.SpaceY+250, textWidth("build a house")+20, -50);
            fill(0);
            text("build a house", build.SpaceXC+150, 3*build.SpaceY+250); 
            break;   
            
          case 4:
            textFont(Calibri);
            fill(255);
            rect(build.SpaceXC+140, 3*build.SpaceY+260, textWidth("click to place it")+20, -50);
            fill(0);
            text("click to place it", build.SpaceXC+150, 3*build.SpaceY+250); 
            break;
            
          case 5:
            textFont(Calibri);
            arrow(width-800, height-330, width-600,height-130, -1, 1); 
            noStroke();
            fill(255);
            rect(build.SpaceXC-60, 3*build.SpaceY+460, textWidth("press expectation to see the expected results of a simulation")+20, -50);
            fill(0);
            text("press expectation to see the expected results of a simulation", build.SpaceXC-50, 3*build.SpaceY+450); 
            break; 
            
          case 6:
            textFont(Calibri);
            noStroke();
            fill(255);
            rect(width/2-textWidth("if more energy is used, than produced, you lose")/2-10, height/2+10, textWidth("if more energy is used, than produced, you lose")+20, -50);
            fill(0);
            text("if more energy is used, than produced, you lose", width/2-textWidth("if more energy is used, than produced, you lose")/2, height/2); 
            break; 
            
          case 7:
            textFont(Calibri);
            noStroke();
            fill(255);
            rect(width/2-textWidth("if your money runs out, you lose")/2-10, height/2+10, textWidth("if your money runs out, you lose")+20, -50);
            fill(0);
            text("if your money runs out, you lose", width/2-textWidth("if your money runs out, you lose")/2, height/2); 
            break;
            
          default: break;
        }
      }
}
//buttons CMain
//opens the build window when BBuild is pressed
public void BBuild() {
  if(window != Window.Taxes){
    window = Window.Build;
    main.hide();
    build.display();
    if(Step == 0){
     Step = 1; 
    }
  }
}
//opens the window to enter the simulation duration when BSimulate is pressed
public void BSimulate(){
  if(window != Window.Taxes){
    Simulate = true;
    Simulation.open();
    window = Window.Simulate;
    main.hide();
  }
}
//opens the expextation when BExpectation is pressed
public void BExpectation(){
  if(window != Window.Taxes){
    Simulate = false;
    report.expectation();
    if(Step == 5){
      Step = 6;
    }
  }
}
//opens the menu when BMenu is pressed
public void BExit(){
  runSketch(new String[]{"CMenu"}, Menu);
}
//zooms when SZoom is moved
public void SZoom() {
  try{
    if(window != Window.Taxes){
      if(SZoom.isMouseOver()){
        float posX = main.PosX/main.Zoom;
        float posY = main.PosY/main.Zoom;
        main.Zoom = SZoom.getValue();
        main.PosX = posX*main.Zoom;
        main.PosY = posY*main.Zoom;
        main.display();
      }
    }
  } catch (NullPointerException e){
  }
}
//buttons CChoose
//goes back to build choose when BChooseExit is pressed
public void BChooseExit(){
  choose.hide();
  build.display();
}
//builds the large version of an object
public void BLarge(){
  fill(main.Dark);
  textFont(Calibri);
  switch(choose.type){
    case 0: 
      if(Money > AKW.InvestmentCost){
        if(Workers >= 5000){
          Workers -= 5000;
          CAKW AKW = new CAKW();
          Object.add(AKW);
          BuildingObject = AKW;
          AKW.build();
          choose.hide();
       }else{
          choose.hide();
          build.display();
          text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
        }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
    
    case 1:
      if(Money > Coal.InvestmentCost){
        if(Workers >= 1380){
          Workers -= 1380;
          CCoal Coal = new CCoal();
          Object.add(Coal);
          BuildingObject = Coal;
          Coal.build();
          choose.hide();
       }else{
          choose.hide();
          build.display();
          text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
        }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
    case 2:
      CWindbig Windl = new CWindbig();
      if(Money > Windl.InvestmentCost){
        BuildingObject = Windl;
        Object.add(Windl);
        Windl.build();
        choose.hide();
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
    case 3:
      CSolarbig Solarl = new CSolarbig();
      if(Money > Solarl.InvestmentCost){
        BuildingObject = Solarl;
        Object.add(Solarl);
        Solarl.build();
        choose.hide();
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
    case 4:
      CHouseholdbig HHl = new CHouseholdbig();
      if(Money > HHl.InvestmentCost){
        Object.add(HHl);
        BuildingObject = HHl;
        HHl.build();
        Workers += 650;
        if(Step == 3){
          Step = 4;
        }
        choose.hide();
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
     case 5:
       CIndustrialBuildingbig IBl = new CIndustrialBuildingbig();
       if(Money > IBl.InvestmentCost){
         if(Workers >= 1000){
            Workers -= 1000;
            Object.add(IBl);
            BuildingObject = IBl;
            IBl.build();
            choose.hide();
         }else{
            choose.hide();
            build.display();
            text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
          }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }  
      break;
      
    case 6:
      CStoragePlant PSW = new CStoragePlant();
      if(Money > PSW.InvestmentCost){
         if(Workers >= 8){
            Workers -= 8;
            Object.add(PSW);
            BuildingObject = PSW;
            PSW.build();
            choose.hide();
         }else{
            choose.hide();
            build.display();
            text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
          }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
    default: break;
  }
}

//builds the small version of an object
public void BSmall(){
  fill(main.Dark);
  textFont(Calibri);
  switch(choose.type){
    case 0: 
      CAKWsmall AKWs = new CAKWsmall();
      if(Money > AKWs.InvestmentCost){
        if(Workers >= 50){
          Workers -= 50;
          Object.add(AKWs);
          BuildingObject = AKWs;
          AKWs.build();
          choose.hide();
        }else{
          choose.hide();
          build.display();
          text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
        }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
    
    case 1: 
      CCoalsmall Coals = new CCoalsmall();
      if(Money > Coals.InvestmentCost){
        if(Workers >= 14){
          Workers -= 14;
          Object.add(Coals);
          BuildingObject = Coals;
          Coals.build();
          choose.hide();
        }else{
          choose.hide();
          build.display();
          text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
        }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
    case 2: 
      if(Money > Wind.InvestmentCost){
        CWind Wind = new CWind();
        BuildingObject = Wind;
        Object.add(Wind);
        Wind.build();
        choose.hide();
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
    case 3:
      if(Money > Solar.InvestmentCost){
        CSolar Solar = new CSolar();
        BuildingObject = Solar;
        Object.add(Solar);
        Solar.build();
        choose.hide();
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
    case 4: 
      if(Money > HH.InvestmentCost){
        CHousehold Household = new CHousehold();
        Object.add(Household);
        BuildingObject = Household;
        Household.build();
        Workers += 65;
        if(Step == 3){
          Step = 4;
        }
        choose.hide();
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
    case 5:
      if(Money > IB.InvestmentCost){
        if (Workers >= 100){
          Workers -= 100;
          CIndustrialBuilding IB = new CIndustrialBuilding();
          Object.add(IB);
          BuildingObject = IB;
          IB.build();
          choose.hide();
        }else{
          choose.hide();
          build.display();
          text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
        }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }
      break;
      
    case 6:
      CStoragePlantsmall PSW = new CStoragePlantsmall();
      if(Money > PSW.InvestmentCost){
         if(Workers >= 1){
            Workers -= 1;
            Object.add(PSW);
            BuildingObject = PSW;
            PSW.build();
            choose.hide();
         }else{
            choose.hide();
            build.display();
            text("not enough workers", width/2-textWidth("not enough workers")/2, height/2);
          }
      }else {
        choose.hide();
        build.display();
        text("not enough money", width/2-textWidth("not enough money")/2, height/2);
      }  
    default: break;
  }
}

//buttons CBuild
//exit
public void BBuildExit(){
  build.hide();
  main.display();
  window = Window.Main;
}
//opens the window where you can choose the size
public void BBuildAKW(){
  choose.type = 0;
  build.hide();
  choose.show();
}
//opens the window where you can choose the size
public void BBuildCoal(){
  choose.type = 1;
  build.hide();
  choose.show();
}
//opens the window where you can choose the size
public void BBuildWind(){
  choose.type = 2;
  build.hide();
  choose.show();
}
//opens the window where you can choose the size
public void BBuildPV(){
  choose.type = 3;
  build.hide();
  choose.show();
}
//opens the window where you can choose the size
public void BBuildHH(){
  choose.type = 4;
  build.hide();
  choose.show();
}
//opens the window where you can choose the size
public void BBuildIB(){
  choose.type = 5;
  build.hide();
  choose.show();
}
//opens the window where you can choose the size
public void BBuildPSW(){
  choose.type = 6;
  build.hide();
  choose.show();
}


//details buttons
//opens the details window, tells it which object has to be explained and gives the information abou the license of the image
public void BDetailsAKW(){
  build.hide();
  Objects = AKW;
  CAKWsmall AKWs = new CAKWsmall();
  Objects2 = AKWs;
  DetailsImage = loadImage("ImgCompare.jpg");
  DetailsTitle = "nuclear power plant";
  DetailsTitle2 = "small version";
  details.ImageName = "Nuclear Powerplant Low-poly ";
  details.ImageCreator = "Scilence ";
  details.LinkImage = "https://sketchfab.com/3d-models/nuclear-powerplant-low-poly-44100dd4134b40a1a8bb6a0490a2d83d";
  details.LinkCreator = "https://sketchfab.com/Scilence";
  window = Window.Details;
  details.display();
 
  fill(0,0,0);
  textFont(Calibri, 40);
  text("total cost in million", 40, 380);
  text("month", (40+width/2+160)/2-textWidth("month")/2, height-40);
  
  fill(0,80,0);
  text("compared to other power plants:", 40, 330);
  
  fill(255, 127, 0);
  text("coal", width/2+300, 350+(height-500)/4*4-40);
  fill(255, 182, 193);
  text("nuclear", width/2+300, 350+(height-500)/4-40);
  fill(0,0,255);
  text("wind", width/2+300, 350+(height-500)/4*2-40);
  fill(255,0,0);
  text("solar", width/2+300, 350+(height-500)/4*3-40);
  
  textFont(Calibri, 20);

}
//opens the details window, tells it which object has to be explained and gives the information abou the license of the image
public void BDetailsCoal(){
  build.hide();
  Objects = Coal;
  CCoalsmall Coals = new CCoalsmall();
  Objects2 = Coals;
  DetailsImage = loadImage("ImgCompare.jpg");
  DetailsTitle = "coal-fired power station";
  DetailsTitle2 = "small version";
  details.ImageName = "Low Poly Coal Plant stylized - animated ";
  details.ImageCreator = "ClimateHackerz ";
  details.LinkImage = "https://sketchfab.com/3d-models/low-poly-coal-plant-stylized-animated-38d9172a0e1740289e29f26143e4b594";
  details.LinkCreator = "https://sketchfab.com/ClimateHackerz";
  window = Window.Details;
  details.display();

  fill(0,0,0);
  textFont(Calibri, 40);
  text("total cost in million", 40, 380);
  text("month", (40+width/2+160)/2-textWidth("month")/2, height-40);
  
  fill(0,80,0);
  text("compared to other power plants:", 40, 330);
  
  fill(255, 127, 0);
  text("coal", width/2+300, 350+(height-500)/4*4-40);
  fill(255, 182, 193);
  text("nuclear", width/2+300, 350+(height-500)/4-40);
  fill(0,0,255);
  text("wind", width/2+300, 350+(height-500)/4*2-40);
  fill(255,0,0);
  text("solar", width/2+300, 350+(height-500)/4*3-40);
  
  textFont(Calibri, 20);

}
//opens the details window, tells it which object has to be explained and gives the information abou the license of the image
public void BDetailsWind(){
  build.hide();
  Objects = Wind;
  CWindbig Windl = new CWindbig();
  Objects2 = Windl;
  DetailsImage = loadImage("ImgDetailsWind2.jpg");
  DetailsTitle = "wind turbine";
  DetailsTitle2 = "large version";
  details.ImageName = "Wind Turbine ";
  details.ImageCreator = "DoobiDooba ";
  details.LinkImage = "https://sketchfab.com/3d-models/wind-turbine-285032402a8543ae8bf3e3c4d8c9f98a";
  details.LinkCreator = "https://sketchfab.com/DoobiDooba";
  window = Window.Details;
  details.display();
}
//opens the details window, tells it which object has to be explained and gives the information abou the license of the image
public void BDetailsPV(){
  build.hide();
  Objects = Solar;
  CSolarbig Solarl = new CSolarbig();
  Objects2 = Solarl;
  DetailsImage = loadImage("ImgDetailsSolar4.png");
  DetailsTitle = "solar panel";
  DetailsTitle2 = "large version";
  details.ImageName = "soler panel setup ";
  details.ImageCreator = "kking88gb ";
  details.LinkImage = "https://sketchfab.com/3d-models/soler-panel-setup-087f976a313f401da2d38f0df73905ff";
  details.LinkCreator = "https://sketchfab.com/kking88gb";
  window = Window.Details;
  details.display();
}
//opens the details window, tells it which object has to be explained and gives the information abou the license of the image
public void BDetailsHH(){
  build.hide();
  Objects = HH;
  CHouseholdbig HHl = new CHouseholdbig();
  Objects2 = HHl;
  DetailsImage = ImgHH;
  DetailsTitle = "Household";
  DetailsTitle2 = "large version";
  details.ImageName = "European House #1 ";
  details.ImageCreator = "Satik64 ";
  details.LinkImage = "https://sketchfab.com/3d-models/european-house-1-a81c9bcf068f47ccb737bead5fac3e0d";
  details.LinkCreator = "https://sketchfab.com/Satik64";
  window = Window.Details;
  details.display();
  if(Step == 1){
    Step = 2; 
  }
}
//opens the details window, tells it which object has to be explained and gives the information abou the license of the image
public void BDetailsIB(){
  build.hide();
  Objects = IB;
  CIndustrialBuildingbig IBl = new CIndustrialBuildingbig();
  Objects2 = IBl;
  DetailsImage = ImgIB;
  DetailsTitle = "industrial building";
  DetailsTitle2 = "large version";
  details.ImageName = "Victorian Factory ";
  details.ImageCreator = "Paolo Mercogliano ";
  details.LinkImage = "https://sketchfab.com/3d-models/victorian-factory-961eb80bb017465a8a900fb0bd0e8404";
  details.LinkCreator = "https://sketchfab.com/paolo.mercoglia";
  window = Window.Details;
  details.display();
}
//opens the details window, tells it which object has to be explained and gives the information abou the license of the image
public void BDetailsPSW(){
  build.hide();
  Objects = PSW;
  Objects2 = PSWs;
  DetailsImage = ImgPSW;
  DetailsTitle = "storage plant";
  DetailsTitle2 = "small version";
  details.ImageName = "Snowy Water tank ";
  details.ImageCreator = "Polygon Experts ";
  details.LinkImage = "https://sketchfab.com/3d-models/snowy-water-tank-b9cf4603062b4b93b10cb83e07ac596b";
  details.LinkCreator = "https://sketchfab.com/polygonexperts";
  window = Window.Details;
  details.display();
  fill(main.Dark);
  textFont(Calibri, 40);
  text("this doesn't produce electricity. It stores it.", 40, 380);
}

//button CDetails (go back to build)
public void BDetailsExit(){
  details.hide();
  build.display();
  window = Window.Build;
  if(Step == 2){
    Step = 3; 
  }
}

//buttons CReport
//closes the report and, if it was a simulation, opens the window to pay taxes
public void BReportExit(){
  report.hide();
  if(Simulate){
    main.display();
    Taxes.open();
    window = Window.Taxes;
  } else{
    main.display();
    window = Window.Main;
  }
  if(Step == 6){
    Step = 7; 
  }
}

//buttons CStart
//starts a new game
public void BStartNew(){
  start.hide();
  startEndless.open();
}
//loads the objects and data from the last stored game and continues it
public void BContinue(){
  try{
    String[] objects = loadStrings("data/Object.txt");
    for(int i = 0; i < objects.length; i++){
      String[] object = split(objects[i], ' ');
      switch(object[0]){
       case "AKW": CAKW AKW = new CAKW(); AKW.ShiftX = Float.parseFloat(object[1]); AKW.ShiftY = Float.parseFloat(object[2]); Object.add(AKW);break;
       case "AKWs": CAKWsmall AKWs = new CAKWsmall(); AKWs.ShiftX = Float.parseFloat(object[1]); AKWs.ShiftY = Float.parseFloat(object[2]); Object.add(AKWs);break;
       case "Coal": CCoal Coal = new CCoal(); Coal.ShiftX = Float.parseFloat(object[1]); Coal.ShiftY = Float.parseFloat(object[2]); Object.add(Coal);break;
       case "Coals": CCoalsmall Coals = new CCoalsmall(); Coals.ShiftX = Float.parseFloat(object[1]); Coals.ShiftY = Float.parseFloat(object[2]); Object.add(Coals);break;
       case "HouseHold": CHousehold HH = new CHousehold(); HH.ShiftX = Float.parseFloat(object[1]); HH.ShiftY = Float.parseFloat(object[2]); Object.add(HH);break;
       case "HouseHoldl": CHouseholdbig HHl = new CHouseholdbig(); HHl.ShiftX = Float.parseFloat(object[1]); HHl.ShiftY = Float.parseFloat(object[2]); Object.add(HHl);break;
       case "IndustrialBuilding": CIndustrialBuilding IB = new CIndustrialBuilding(); IB.ShiftX = Float.parseFloat(object[1]); IB.ShiftY = Float.parseFloat(object[2]); Object.add(IB);break;
       case "IndustrialBuildingl": CIndustrialBuildingbig IBl = new CIndustrialBuildingbig(); IBl.ShiftX = Float.parseFloat(object[1]); IBl.ShiftY = Float.parseFloat(object[2]); Object.add(IBl);break;
       case "Solar": CSolar PV = new CSolar(); PV.ShiftX = Float.parseFloat(object[1]); PV.ShiftY = Float.parseFloat(object[2]); Object.add(PV);break;
       case "Solarl": CSolarbig PVl = new CSolarbig(); PVl.ShiftX = Float.parseFloat(object[1]); PVl.ShiftY = Float.parseFloat(object[2]); Object.add(PVl);break;
       case "Wind": CWind Wind = new CWind(); Wind.ShiftX = Float.parseFloat(object[1]); Wind.ShiftY = Float.parseFloat(object[2]); Object.add(Wind);break;
       case "Windl": CWindbig Windl = new CWindbig(); Windl.ShiftX = Float.parseFloat(object[1]); Windl.ShiftY = Float.parseFloat(object[2]); Object.add(Windl);break;
       case "PSW": CStoragePlant PSW = new CStoragePlant(); PSW.ShiftX =  Float.parseFloat(object[1]); PSW.ShiftY = Float.parseFloat(object[2]); Object.add(PSW);break;
       case "PSWs": CStoragePlantsmall PSWs = new CStoragePlantsmall(); PSWs.ShiftX =  Float.parseFloat(object[1]); PSWs.ShiftY = Float.parseFloat(object[2]); Object.add(PSWs);break;
       default: break;
      }
    }
  } catch (ArrayIndexOutOfBoundsException e){
  }

  try{
    String[] data = loadStrings("data/Data.txt");
    Month = Integer.parseInt(data[0]);
    Money = Math.round(Double.parseDouble(data[1]));
    Energy = Math.round(Double.parseDouble(data[2]));
    CO2 = Math.round(Double.parseDouble(data[3]));
    Tax = Integer.parseInt(data[5]);
    Workers = Integer.parseInt(data[6]);
    Taxe = Boolean.parseBoolean(data[7]);
    Year = Integer.parseInt(data[8]);
    main.display();
    //opens the taxes window if necessairy
    if(Taxe){
       Taxes.open();
       window = Window.Taxes;
    } else {
      window = Window.Main;
    }
    start.hide();
  } catch (ArrayIndexOutOfBoundsException e){
  }
}

//buttons and sliders CStartEndless
//closes and reopens the window when the slider is moved (to reload the text)
public void SEmissionTaxes(){
  try{
    startEndless.close();
    startEndless.open();
  } catch (NullPointerException e){
  } 
}

//starts the game if the budget is a number and within the accepted range
public void BOK(){
  main.display();
  startEndless.close();
  window = Window.Main;
  Tutorial = true;
}
//closes and reopens the window when the slider is moved (to reload the text)
public void SBudget(){
  try{
    SEmissionTaxes2.setValue(SEmissionTaxes.getValue());
    startEndless.close();
    SEmissionTaxes2.show();
    startEndless.open();
  } catch (NullPointerException e){
  }
}
//checks if the entered duration is acceptable and starts the simulation
public void BSimulation(){
  if(TSimulation.getText().trim().length() > 9){
    TSimulation.setColor(color(255,0,0));
    TSimulation.setText("number is too big");
  } else {
    try {
      Duration = Integer.parseInt(TSimulation.getText());
      if(Duration < 1){
        TSimulation.setColor(color(255,0,0));
        TSimulation.setText("number is too small");
      }else{
        report.simulate();
        Simulation.hide();
      }
    } catch (NumberFormatException e) {
      TSimulation.setColor(color(255,0,0));
      TSimulation.setText("not an integer");
    }
  }
}

//called when the mouse is pressed...
void mousePressed() {
  SEmissionTaxes2.hide();
  if(Step == 4){
    Step = 5;
  }
  if(Step == 7){
    Tutorial = false;
    String[] first = new String[1];
    first[0] = "1";
    saveStrings("data/First.txt", first);
    Step = 8;
  }
  switch(window) {
  case Dead: 
    Object = new ArrayList<ACEnergyObject>();
    Month = 1;
    Year = 0;
    Money = 0;
    Energy = 0;
    CO2 = 0;
    Workers = 0;
    start.open(); 
    window=Window.Start; 
    break;
  
  //...on the window "Main"
  case Main:  
    main.Grabbed = true;
    break;
    
  //...while building a new object
  case Building:
    if(BuildingObject.ground()){
      BuildingObject.place();
      window = Window.Main;
    }
    break;
  
  //...on the window "Taxes"
  case Taxes: Taxes.hide(); Taxes.open();break;
    
  //...on the window "Details"
  case Details:
    if(mouseX > width-30-textWidth(details.ImageName)-textWidth(details.By)-textWidth(details.ImageCreator)-textWidth(details.Licensed)-textWidth(details.Attribution) && mouseX < width-30-textWidth(details.By)-textWidth(details.ImageCreator)-textWidth(details.Licensed)-textWidth(details.Attribution) && mouseY > height-60 && mouseY < height-20){
       link(details.LinkImage); 
    } else if(mouseX > width-30-textWidth(details.ImageCreator)-textWidth(details.Licensed)-textWidth(details.Attribution) && mouseX < width-30-textWidth(details.Licensed)-textWidth(details.Attribution) && mouseY > height-60 && mouseY < height-20){
       link(details.LinkCreator); 
    } else if(mouseX > width-30-textWidth(details.Attribution) && mouseX < width-30 && mouseY > height-60 && mouseY < height-20){
       link("https://creativecommons.org/licenses/by/4.0/"); 
    }
  default: break;
  }
}

//called when the mouse is released...
void mouseReleased() {
  switch(window) {
    
  //...on the window "Main"
  case Main:  
    main.Grabbed = false;
    break;
  default: break;
  }
}

//called when the MouseWheel is turned
void mouseWheel(MouseEvent event) {
  if(window == Window.Main){
    float e = event.getCount();
    if(main.Zoom-5*e <= 3){
      float posX = main.PosX/main.Zoom;
      float posY = main.PosY/main.Zoom;
      main.Zoom = 3;
      main.PosX = posX*main.Zoom;
      main.PosY = posY*main.Zoom;
    }else if(main.Zoom-5*e > 3 && main.Zoom-5*e < 90){
      float posX = main.PosX/main.Zoom;
      float posY = main.PosY/main.Zoom;
      main.Zoom = main.Zoom-5*e;
      main.PosX = posX*main.Zoom;
      main.PosY = posY*main.Zoom;
    }else if(main.Zoom-5*e >= 90){
      float posX = main.PosX/main.Zoom;
      float posY = main.PosY/main.Zoom;
      main.Zoom = 90;
      main.PosX = posX*main.Zoom;
      main.PosY = posY*main.Zoom;
    }
    SZoom.setValue(main.Zoom);
    main.display();
  }
}

//saves the objects and data in text documents
void save2(){
  StringList objectstxt = new StringList();
    for (int i = 0; i < Object.size(); i++){
      ACEnergyObject object = Object.get(i);
      objectstxt.append(object.Kind+" "+Float.toString(object.ShiftX)+" "+Float.toString(object.ShiftY));
    }
    String[] array = objectstxt.array();
    saveStrings("data/Object.txt", array);
    String[] Data = new String[9];
    Data[0] = str(Month);
    Data[1] = str(Money);
    Data[2] = str(Energy);
    Data[3] = str(CO2);
    Data[5] = str(Tax);
    Data[6] = str(Workers);
    Data[7] = str(Taxe);
    Data[8] = str(Year);
    saveStrings("data/Data.txt", Data);
}
//draws an arrow
void arrow(int startx, int starty, int endx, int endy, int right, int down){
  stroke(0);
  strokeWeight(10);
  line(startx, starty, endx, endy);
  line(endx, endy-20*down, endx, endy);
  line(endx+20*right, endy, endx, endy);
}
//called from outside the main window to close the application
void close2(){
  exit(); 
}
